/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.java.lexer;

import com.intellij.lang.java.lexer._JavaLexer;
import com.intellij.lexer.LexerBase;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.TokenType;
import com.intellij.psi.impl.source.tree.JavaDocElementType;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.CharArrayUtil;
import java.io.IOException;
import java.util.Arrays;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JavaLexer
extends LexerBase {
    private static final Set<String> KEYWORDS = ContainerUtil.set("abstract", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "default", "do", "double", "else", "extends", "final", "finally", "float", "for", "goto", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "package", "private", "protected", "public", "return", "short", "static", "strictfp", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "try", "void", "volatile", "while", "true", "false", "null", "non-sealed");
    private static final Set<CharSequence> JAVA9_KEYWORDS = CollectionFactory.createCharSequenceSet(Arrays.asList("open", "module", "requires", "exports", "opens", "uses", "provides", "transitive", "to", "with"));
    private final _JavaLexer myFlexLexer;
    private CharSequence myBuffer;
    private char @Nullable [] myBufferArray;
    private int myBufferIndex;
    private int myBufferEndOffset;
    private int myTokenEndOffset;
    private IElementType myTokenType;
    private int mySymbolLength;

    public static boolean isKeyword(String id, @NotNull LanguageLevel level) {
        if (level == null) {
            JavaLexer.$$$reportNull$$$0(0);
        }
        return KEYWORDS.contains(id) || level.isAtLeast(LanguageLevel.JDK_1_4) && "assert".equals(id) || level.isAtLeast(LanguageLevel.JDK_1_5) && "enum".equals(id);
    }

    public static boolean isSoftKeyword(CharSequence id, @NotNull LanguageLevel level) {
        if (level == null) {
            JavaLexer.$$$reportNull$$$0(1);
        }
        return id != null && (level.isAtLeast(LanguageLevel.JDK_1_9) && JAVA9_KEYWORDS.contains(id) || level.isAtLeast(LanguageLevel.JDK_10) && "var".contentEquals(id) || level.isAtLeast(LanguageLevel.JDK_16) && "record".contentEquals(id) || level.isAtLeast(LanguageLevel.JDK_14) && "yield".contentEquals(id) || level.isAtLeast(LanguageLevel.JDK_17) && ("sealed".contentEquals(id) || "permits".contentEquals(id)) || level.isAtLeast(LanguageLevel.JDK_19_PREVIEW) && "when".contentEquals(id));
    }

    public JavaLexer(@NotNull LanguageLevel level) {
        if (level == null) {
            JavaLexer.$$$reportNull$$$0(2);
        }
        this.mySymbolLength = 1;
        this.myFlexLexer = new _JavaLexer(level);
    }

    @Override
    public void start(@NotNull CharSequence buffer, int startOffset, int endOffset, int initialState) {
        if (buffer == null) {
            JavaLexer.$$$reportNull$$$0(3);
        }
        this.myBuffer = buffer;
        this.myBufferArray = CharArrayUtil.fromSequenceWithoutCopying(buffer);
        this.myBufferIndex = startOffset;
        this.myBufferEndOffset = endOffset;
        this.myTokenType = null;
        this.myTokenEndOffset = startOffset;
        this.mySymbolLength = 1;
        this.myFlexLexer.reset(this.myBuffer, startOffset, endOffset, 0);
    }

    @Override
    public int getState() {
        return 0;
    }

    @Override
    public IElementType getTokenType() {
        this.locateToken();
        return this.myTokenType;
    }

    @Override
    public int getTokenStart() {
        return this.myBufferIndex;
    }

    @Override
    public int getTokenEnd() {
        this.locateToken();
        return this.myTokenEndOffset;
    }

    @Override
    public void advance() {
        this.locateToken();
        this.myTokenType = null;
    }

    private void locateToken() {
        if (this.myTokenType != null) {
            return;
        }
        if (this.myTokenEndOffset == this.myBufferEndOffset) {
            this.myBufferIndex = this.myBufferEndOffset;
            return;
        }
        this.myBufferIndex = this.myTokenEndOffset;
        char c = this.locateCharAt(this.myBufferIndex);
        switch (c) {
            case '\t': 
            case '\n': 
            case '\f': 
            case '\r': 
            case ' ': {
                this.myTokenType = TokenType.WHITE_SPACE;
                this.myTokenEndOffset = this.getWhitespaces(this.myBufferIndex + this.mySymbolLength);
                break;
            }
            case '/': {
                if (this.myBufferIndex + this.mySymbolLength >= this.myBufferEndOffset) {
                    this.myTokenType = JavaTokenType.DIV;
                    this.myTokenEndOffset = this.myBufferEndOffset;
                    break;
                }
                int l1 = this.mySymbolLength;
                char nextChar = this.locateCharAt(this.myBufferIndex + l1);
                if (nextChar == '/') {
                    this.myTokenType = JavaTokenType.END_OF_LINE_COMMENT;
                    this.myTokenEndOffset = this.getLineTerminator(this.myBufferIndex + l1 + this.mySymbolLength);
                    break;
                }
                if (nextChar == '*') {
                    int l2 = this.mySymbolLength;
                    if (this.myBufferIndex + l1 + l2 < this.myBufferEndOffset && this.locateCharAt(this.myBufferIndex + l1 + l2) == '*') {
                        int l3 = this.mySymbolLength;
                        if (this.myBufferIndex + l1 + l2 + l3 < this.myBufferEndOffset && this.locateCharAt(this.myBufferIndex + l1 + l2 + l3) == '/') {
                            this.myTokenType = JavaTokenType.C_STYLE_COMMENT;
                            this.myTokenEndOffset = this.myBufferIndex + l1 + l2 + l3 + this.mySymbolLength;
                            break;
                        }
                        this.myTokenType = JavaDocElementType.DOC_COMMENT;
                        this.myTokenEndOffset = this.getClosingComment(this.myBufferIndex + l1 + l2 + l3);
                        break;
                    }
                    this.myTokenType = JavaTokenType.C_STYLE_COMMENT;
                    this.myTokenEndOffset = this.getClosingComment(this.myBufferIndex + l1 + l2 + this.mySymbolLength);
                    break;
                }
                this.flexLocateToken();
                break;
            }
            case '#': {
                if (this.myBufferIndex == 0 && this.mySymbolLength == 1 && this.myBufferEndOffset > 1 && this.charAt(1) == '!' && this.mySymbolLength == 1) {
                    this.myTokenType = JavaTokenType.END_OF_LINE_COMMENT;
                    this.myTokenEndOffset = this.getLineTerminator(2);
                    break;
                }
                this.flexLocateToken();
                break;
            }
            case '\'': {
                this.myTokenType = JavaTokenType.CHARACTER_LITERAL;
                this.myTokenEndOffset = this.getClosingQuote(this.myBufferIndex + this.mySymbolLength, '\'');
                break;
            }
            case '\"': {
                int l1 = this.mySymbolLength;
                if (this.myBufferIndex + l1 < this.myBufferEndOffset && this.locateCharAt(this.myBufferIndex + l1) == '\"') {
                    int l2 = this.mySymbolLength;
                    if (this.myBufferIndex + l1 + l2 < this.myBufferEndOffset && this.locateCharAt(this.myBufferIndex + l1 + l2) == '\"') {
                        this.myTokenType = JavaTokenType.TEXT_BLOCK_LITERAL;
                        this.myTokenEndOffset = this.getTextBlockEnd(this.myBufferIndex + l1 + l2);
                        break;
                    }
                    this.myTokenType = JavaTokenType.STRING_LITERAL;
                    this.myTokenEndOffset = this.myBufferIndex + l1 + l2;
                    break;
                }
                this.myTokenType = JavaTokenType.STRING_LITERAL;
                this.myTokenEndOffset = this.getClosingQuote(this.myBufferIndex + l1, '\"');
                break;
            }
            default: {
                this.flexLocateToken();
            }
        }
        if (this.myTokenEndOffset > this.myBufferEndOffset) {
            this.myTokenEndOffset = this.myBufferEndOffset;
        }
    }

    private int getWhitespaces(int offset) {
        char c;
        int pos;
        for (pos = offset; pos < this.myBufferEndOffset && ((c = this.locateCharAt(pos)) == ' ' || c == '\t' || c == '\n' || c == '\r' || c == '\f'); pos += this.mySymbolLength) {
        }
        return pos;
    }

    private void flexLocateToken() {
        try {
            this.myFlexLexer.goTo(this.myBufferIndex);
            this.myTokenType = this.myFlexLexer.advance();
            this.myTokenEndOffset = this.myFlexLexer.getTokenEnd();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private int getClosingQuote(int offset, char quoteChar) {
        int pos;
        for (pos = offset; pos < this.myBufferEndOffset; pos += this.mySymbolLength) {
            char c = this.locateCharAt(pos);
            if (c == '\\') {
                if ((pos += this.mySymbolLength) >= this.myBufferEndOffset) continue;
                this.locateCharAt(pos);
                continue;
            }
            if (c == quoteChar) {
                return pos + this.mySymbolLength;
            }
            if (c != '\n' && c != '\r' || this.mySymbolLength != 1) continue;
            return pos;
        }
        return pos;
    }

    private int getClosingComment(int offset) {
        char c;
        int pos = offset;
        while (pos < this.myBufferEndOffset && ((c = this.locateCharAt(pos)) != '*' || (pos += this.mySymbolLength) >= this.myBufferEndOffset || this.locateCharAt(pos) != '/')) {
        }
        return pos + this.mySymbolLength;
    }

    private int getLineTerminator(int offset) {
        char c;
        int pos;
        for (pos = offset; pos < this.myBufferEndOffset && (c = this.locateCharAt(pos)) != '\r' && c != '\n'; pos += this.mySymbolLength) {
        }
        return pos;
    }

    private int getTextBlockEnd(int offset) {
        int pos = offset;
        while ((pos = this.getClosingQuote(pos + this.mySymbolLength, '\"')) < this.myBufferEndOffset) {
            int l1;
            char c = this.locateCharAt(pos);
            if (c == '\\') {
                this.locateCharAt(pos += this.mySymbolLength);
                continue;
            }
            if (c != '\"' || pos + (l1 = this.mySymbolLength) >= this.myBufferEndOffset || this.locateCharAt(pos + l1) != '\"') continue;
            return pos + l1 + this.mySymbolLength;
        }
        return pos;
    }

    private char charAt(int offset) {
        return this.myBufferArray != null ? this.myBufferArray[offset] : this.myBuffer.charAt(offset);
    }

    private char locateCharAt(int offset) {
        this.mySymbolLength = 1;
        char first2 = this.charAt(offset);
        if (first2 != '\\') {
            return first2;
        }
        int pos = offset + 1;
        if (pos < this.myBufferEndOffset && this.charAt(pos) == '\\') {
            return first2;
        }
        boolean escaped = true;
        int i = offset;
        while (--i >= 0 && this.charAt(i) == '\\') {
            escaped = !escaped;
        }
        if (!escaped) {
            return first2;
        }
        if (pos < this.myBufferEndOffset && this.charAt(pos) != 'u') {
            return first2;
        }
        while (++pos < this.myBufferEndOffset && this.charAt(pos) == 'u') {
        }
        if (pos + 3 >= this.myBufferEndOffset) {
            return first2;
        }
        int result2 = 0;
        int max = pos + 4;
        while (pos < max) {
            result2 <<= 4;
            char c = this.charAt(pos);
            if ('0' <= c && c <= '9') {
                result2 += c - 48;
            } else if ('a' <= c && c <= 'f') {
                result2 += c - 97 + 10;
            } else if ('A' <= c && c <= 'F') {
                result2 += c - 65 + 10;
            } else {
                return first2;
            }
            ++pos;
        }
        this.mySymbolLength = pos - offset;
        return (char)result2;
    }

    @Override
    @NotNull
    public CharSequence getBufferSequence() {
        CharSequence charSequence = this.myBuffer;
        if (charSequence == null) {
            JavaLexer.$$$reportNull$$$0(4);
        }
        return charSequence;
    }

    @Override
    public int getBufferEnd() {
        return this.myBufferEndOffset;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "level";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buffer";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/java/lexer/JavaLexer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/java/lexer/JavaLexer";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getBufferSequence";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isKeyword";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isSoftKeyword";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "start";
                break;
            }
            case 4: {
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

