/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.ide.plugins.DataLoader;
import com.intellij.util.lang.ZipFilePool;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0012H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0016\u0010\u000b\u001a\u0004\u0018\u00010\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0014"}, d2={"Lcom/intellij/ide/plugins/LocalFsDataLoader;", "Lcom/intellij/ide/plugins/DataLoader;", "basePath", "Ljava/nio/file/Path;", "(Ljava/nio/file/Path;)V", "getBasePath", "()Ljava/nio/file/Path;", "emptyDescriptorIfCannotResolve", "", "getEmptyDescriptorIfCannotResolve", "()Z", "pool", "Lcom/intellij/util/lang/ZipFilePool;", "getPool", "()Lcom/intellij/util/lang/ZipFilePool;", "load", "Ljava/io/InputStream;", "path", "", "toString", "intellij.platform.core.impl"})
@ApiStatus.Internal
public final class LocalFsDataLoader
implements DataLoader {
    @NotNull
    private final Path basePath;

    public LocalFsDataLoader(@NotNull Path basePath) {
        Intrinsics.checkNotNullParameter((Object)basePath, (String)"basePath");
        this.basePath = basePath;
    }

    @NotNull
    public final Path getBasePath() {
        return this.basePath;
    }

    @Override
    @Nullable
    public ZipFilePool getPool() {
        return ZipFilePool.POOL;
    }

    @Override
    public boolean getEmptyDescriptorIfCannotResolve() {
        return true;
    }

    @Override
    @Nullable
    public InputStream load(@NotNull String path) {
        InputStream inputStream;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        try {
            inputStream = Files.newInputStream(this.basePath.resolve(path), new OpenOption[0]);
        }
        catch (NoSuchFileException e) {
            inputStream = null;
        }
        return inputStream;
    }

    @Override
    @NotNull
    public String toString() {
        return ((Object)this.basePath).toString();
    }
}

