/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.diagnostic.PluginException;
import com.intellij.ide.plugins.ClassLoaderConfiguratorKt;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.PluginDependency;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.PluginSet;
import com.intellij.ide.plugins.cl.PluginClassLoader;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.util.SmartList;
import com.intellij.util.lang.ClassPath;
import com.intellij.util.lang.ResourceFile;
import com.intellij.util.lang.UrlClassLoader;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u00002\u00020\u0001:\u00010B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u000eH\u0002J\u0006\u0010\u001a\u001a\u00020\u0018J#\u0010\u001b\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u000e2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u000e0\u001dH\u0002\u00a2\u0006\u0002\u0010\u001eJ\u0018\u0010\u001f\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u000e2\u0006\u0010 \u001a\u00020\u0005H\u0002J\u0016\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u000e2\u0006\u0010$\u001a\u00020\u000eJ\u000e\u0010%\u001a\u00020\"2\u0006\u0010\u0019\u001a\u00020\u000eJ+\u0010&\u001a\u00020'2\u0006\u0010\u0019\u001a\u00020\u000e2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u000e0\u001d2\u0006\u0010)\u001a\u00020\nH\u0002\u00a2\u0006\u0002\u0010*J\u0012\u0010+\u001a\u0004\u0018\u00010,2\u0006\u0010\u0019\u001a\u00020\u000eH\u0002J\u0018\u0010-\u001a\u00020\u00182\u0006\u0010.\u001a\u00020\u000e2\u0006\u0010/\u001a\u00020\u0005H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\"\u0010\u0011\u001a\u0010\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u0014\u0018\u00010\u0012X\u0082\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0015\u0010\u0016\u00a8\u00061"}, d2={"Lcom/intellij/ide/plugins/ClassLoaderConfigurator;", "", "pluginSet", "Lcom/intellij/ide/plugins/PluginSet;", "coreLoader", "Ljava/lang/ClassLoader;", "(Lcom/intellij/ide/plugins/PluginSet;Ljava/lang/ClassLoader;)V", "mainToClassPath", "Ljava/util/IdentityHashMap;", "Lcom/intellij/openapi/extensions/PluginId;", "Lcom/intellij/ide/plugins/ClassLoaderConfigurator$MainInfo;", "pluginPackagePrefixUniqueGuard", "Ljava/util/HashMap;", "", "Lcom/intellij/ide/plugins/IdeaPluginDescriptorImpl;", "getPluginSet", "()Lcom/intellij/ide/plugins/PluginSet;", "resourceFileFactory", "Ljava/util/function/Function;", "Ljava/nio/file/Path;", "Lcom/intellij/util/lang/ResourceFile;", "getResourceFileFactory$annotations", "()V", "checkPackagePrefixUniqueness", "", "module", "configure", "configureCorePluginModuleClassLoader", "deps", "", "(Lcom/intellij/ide/plugins/IdeaPluginDescriptorImpl;[Lcom/intellij/ide/plugins/IdeaPluginDescriptorImpl;)V", "configureDependenciesInOldFormat", "mainDependentClassLoader", "configureDependency", "", "mainDescriptor", "moduleDescriptor", "configureModule", "createPluginClassLoader", "Lcom/intellij/ide/plugins/cl/PluginClassLoader;", "dependencies", "mainInfo", "(Lcom/intellij/ide/plugins/IdeaPluginDescriptorImpl;[Lcom/intellij/ide/plugins/IdeaPluginDescriptorImpl;Lcom/intellij/ide/plugins/ClassLoaderConfigurator$MainInfo;)Lcom/intellij/ide/plugins/cl/PluginClassLoader;", "getCoreUrlClassLoaderIfPossible", "Lcom/intellij/util/lang/UrlClassLoader;", "setPluginClassLoaderForModuleAndOldSubDescriptors", "rootDescriptor", "classLoader", "MainInfo", "intellij.platform.core.impl"})
@ApiStatus.Internal
public final class ClassLoaderConfigurator {
    @NotNull
    private final PluginSet pluginSet;
    @NotNull
    private final ClassLoader coreLoader;
    @NotNull
    private final HashMap<String, IdeaPluginDescriptorImpl> pluginPackagePrefixUniqueGuard;
    @Nullable
    private final Function<Path, ResourceFile> resourceFileFactory;
    @NotNull
    private final IdentityHashMap<PluginId, MainInfo> mainToClassPath;

    /*
     * WARNING - void declaration
     */
    public ClassLoaderConfigurator(@NotNull PluginSet pluginSet, @NotNull ClassLoader coreLoader) {
        Function function;
        ClassLoaderConfigurator classLoaderConfigurator;
        Intrinsics.checkNotNullParameter((Object)pluginSet, (String)"pluginSet");
        Intrinsics.checkNotNullParameter((Object)coreLoader, (String)"coreLoader");
        this.pluginSet = pluginSet;
        this.coreLoader = coreLoader;
        this.pluginPackagePrefixUniqueGuard = new HashMap();
        this.mainToClassPath = new IdentityHashMap();
        ClassLoaderConfigurator classLoaderConfigurator2 = this;
        try {
            classLoaderConfigurator = classLoaderConfigurator2;
            function = MethodHandles.lookup().findStatic(this.coreLoader.loadClass("com.intellij.util.lang.PathClassLoader"), "getResourceFileFactory", MethodType.methodType(Function.class)).invokeExact();
        }
        catch (ClassNotFoundException classNotFoundException) {
            classLoaderConfigurator = classLoaderConfigurator2;
            function = null;
        }
        catch (Throwable ignore) {
            void e;
            classLoaderConfigurator = classLoaderConfigurator2;
            ClassLoaderConfiguratorKt.access$getLog().error((Throwable)e);
            function = null;
        }
        classLoaderConfigurator.resourceFileFactory = function;
    }

    public /* synthetic */ ClassLoaderConfigurator(PluginSet pluginSet, ClassLoader classLoader, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            ClassLoader classLoader2 = ClassLoaderConfigurator.class.getClassLoader();
            Intrinsics.checkNotNullExpressionValue((Object)classLoader2, (String)"ClassLoaderConfigurator::class.java.classLoader");
            classLoader = classLoader2;
        }
        this(pluginSet, classLoader);
    }

    @NotNull
    public final PluginSet getPluginSet() {
        return this.pluginSet;
    }

    private static /* synthetic */ void getResourceFileFactory$annotations() {
    }

    public final boolean configureDependency(@NotNull IdeaPluginDescriptorImpl mainDescriptor, @NotNull IdeaPluginDescriptorImpl moduleDescriptor) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)mainDescriptor, (String)"mainDescriptor");
        Intrinsics.checkNotNullParameter((Object)moduleDescriptor, (String)"moduleDescriptor");
        boolean bl2 = bl = !Intrinsics.areEqual((Object)mainDescriptor, (Object)moduleDescriptor);
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-ClassLoaderConfigurator$configureDependency$32 = false;
            String $i$a$-assert-ClassLoaderConfigurator$configureDependency$32 = mainDescriptor + " != " + moduleDescriptor;
            throw new AssertionError((Object)$i$a$-assert-ClassLoaderConfigurator$configureDependency$32);
        }
        PluginId pluginId = mainDescriptor.getPluginId();
        boolean $i$a$-assert-ClassLoaderConfigurator$configureDependency$32 = Intrinsics.areEqual((Object)pluginId, (Object)moduleDescriptor.getPluginId());
        if (_Assertions.ENABLED && !$i$a$-assert-ClassLoaderConfigurator$configureDependency$32) {
            boolean bl3 = false;
            String string2 = "pluginId '" + pluginId + "' != moduleDescriptor.pluginId '" + moduleDescriptor.getPluginId() + '\'';
            throw new AssertionError((Object)string2);
        }
        ClassLoader classLoader = mainDescriptor.getPluginClassLoader();
        Intrinsics.checkNotNull((Object)classLoader, (String)"null cannot be cast to non-null type com.intellij.ide.plugins.cl.PluginClassLoader");
        PluginClassLoader mainClassLoader = (PluginClassLoader)classLoader;
        ((Map)this.mainToClassPath).put(pluginId, new MainInfo(mainClassLoader));
        return this.configureModule(moduleDescriptor);
    }

    public final void configure() {
        for (IdeaPluginDescriptorImpl module : this.pluginSet.getEnabledModules()) {
            this.configureModule(module);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean configureModule(@NotNull IdeaPluginDescriptorImpl module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        this.checkPackagePrefixUniqueness(module);
        boolean isMain = module.moduleName == null;
        Collection<IdeaPluginDescriptorImpl> $this$toTypedArray$iv = this.pluginSet.moduleGraph.getDependencies(module);
        boolean $i$f$toTypedArray = false;
        Collection<IdeaPluginDescriptorImpl> thisCollection$iv = $this$toTypedArray$iv;
        IdeaPluginDescriptorImpl[] dependencies = thisCollection$iv.toArray(new IdeaPluginDescriptorImpl[0]);
        ClassLoaderConfiguratorKt.sortDependenciesInPlace(dependencies);
        if (isMain) {
            if (module.useCoreClassLoader || Intrinsics.areEqual((Object)module.getPluginId(), (Object)PluginManagerCore.CORE_ID)) {
                this.setPluginClassLoaderForModuleAndOldSubDescriptors(module, this.coreLoader);
                return true;
            }
            List<Path> files2 = module.jarFiles;
            if (files2 == null) {
                if (!module.isUseIdeaClassLoader) {
                    ClassLoaderConfiguratorKt.access$getLog().error("jarFiles is not set for " + module);
                }
                List list = Collections.emptyList();
                Intrinsics.checkNotNull(list);
                files2 = list;
            }
            List libDirectories = new SmartList();
            Path libDir = module.path.resolve("lib");
            if (Files.exists(libDir, new LinkOption[0])) {
                libDirectories.add(((Object)libDir.toAbsolutePath()).toString());
            }
            boolean mimicJarUrlConnection = !module.isBundled() && !Intrinsics.areEqual((Object)module.getVendor(), (Object)"JetBrains");
            ClassPath pluginClassPath = new ClassPath(files2, ClassLoaderConfiguratorKt.access$getDEFAULT_CLASSLOADER_CONFIGURATION$p(), this.resourceFileFactory, mimicJarUrlConnection);
            MainInfo mainInfo = new MainInfo(pluginClassPath, files2, libDirectories);
            MainInfo existing = this.mainToClassPath.put(module.getPluginId(), mainInfo);
            if (existing != null) {
                ClassLoaderConfiguratorKt.access$getLog().error(new PluginException("Main module with " + module.getPluginId() + " is already added (existingClassPath=" + existing.files, module.getPluginId()));
            }
            ClassLoader mainDependentClassLoader = module.isUseIdeaClassLoader ? ClassLoaderConfiguratorKt.access$configureUsingIdeaClassloader(mainInfo.files, module) : (ClassLoader)this.createPluginClassLoader(module, dependencies, mainInfo);
            module.setPluginClassLoader(mainDependentClassLoader);
            this.configureDependenciesInOldFormat(module, mainDependentClassLoader);
            return true;
        } else {
            if (module.packagePrefix == null) {
                throw new PluginException("Package is not specified (module=" + module + ')', module.getPluginId());
            }
            boolean files2 = module.pluginDependencies.isEmpty();
            if (_Assertions.ENABLED && !files2) {
                boolean $i$a$-assert-ClassLoaderConfigurator$configureModule$22 = false;
                String $i$a$-assert-ClassLoaderConfigurator$configureModule$22 = "Module " + module + " shouldn't have plugin dependencies: " + module.pluginDependencies;
                throw new AssertionError((Object)$i$a$-assert-ClassLoaderConfigurator$configureModule$22);
            }
            IdeaPluginDescriptorImpl[] $this$any$iv = dependencies;
            boolean $i$f$any = false;
            int n = $this$any$iv.length;
            for (int i = 0; i < n; ++i) {
                IdeaPluginDescriptorImpl element$iv;
                IdeaPluginDescriptorImpl it = element$iv = $this$any$iv[i];
                boolean bl = false;
                if (it.getPluginClassLoader() == null) {
                    return false;
                }
                boolean bl2 = false;
                if (!bl2) continue;
                return false;
            }
            boolean bl = false;
            if (bl) {
                return false;
            }
            if (module.useCoreClassLoader) {
                module.setPluginClassLoader(this.coreLoader);
                return true;
            }
            MainInfo mainInfo = this.mainToClassPath.get(module.getPluginId());
            if (mainInfo == null) {
                if (!Intrinsics.areEqual((Object)module.getPluginId(), (Object)PluginManagerCore.CORE_ID)) throw new PluginException("Cannot find containing plugin " + module.getPluginId() + " for module " + module.moduleName + ' ', module.getPluginId());
                this.configureCorePluginModuleClassLoader(module, dependencies);
                return true;
            } else {
                module.setPluginClassLoader(new PluginClassLoader(mainInfo.files, mainInfo.classPath, dependencies, module, this.coreLoader, ClassLoaderConfiguratorKt.access$createModuleResolveScopeManager(), module.packagePrefix, mainInfo.libDirectories));
            }
        }
        return true;
    }

    private final void configureDependenciesInOldFormat(IdeaPluginDescriptorImpl module, ClassLoader mainDependentClassLoader) {
        for (PluginDependency dependency : module.pluginDependencies) {
            IdeaPluginDescriptorImpl subDescriptor;
            IdeaPluginDescriptorImpl ideaPluginDescriptorImpl;
            if (dependency.subDescriptor == null) continue;
            if (this.pluginSet.findEnabledPlugin(dependency.getPluginId()) != null) {
                IdeaPluginDescriptorImpl ideaPluginDescriptorImpl2;
                IdeaPluginDescriptorImpl it = ideaPluginDescriptorImpl2;
                boolean bl = false;
                ideaPluginDescriptorImpl = it != module ? ideaPluginDescriptorImpl2 : null;
            } else {
                ideaPluginDescriptorImpl = null;
            }
            if (ideaPluginDescriptorImpl == null) continue;
            subDescriptor.setPluginClassLoader(mainDependentClassLoader);
            this.configureDependenciesInOldFormat(subDescriptor, mainDependentClassLoader);
        }
    }

    private final void configureCorePluginModuleClassLoader(IdeaPluginDescriptorImpl module, IdeaPluginDescriptorImpl[] deps) {
        UrlClassLoader coreUrlClassLoader = this.getCoreUrlClassLoaderIfPossible(module);
        if (coreUrlClassLoader == null) {
            this.setPluginClassLoaderForModuleAndOldSubDescriptors(module, this.coreLoader);
            return;
        }
        module.setPluginClassLoader(new PluginClassLoader(Collections.emptyList(), coreUrlClassLoader.getClassPath(), deps, module, this.coreLoader, ClassLoaderConfiguratorKt.access$createModuleResolveScopeManager(), module.packagePrefix, new ArrayList()));
    }

    private final UrlClassLoader getCoreUrlClassLoaderIfPossible(IdeaPluginDescriptorImpl module) {
        UrlClassLoader coreUrlClassLoader;
        ClassLoader classLoader = this.coreLoader;
        UrlClassLoader urlClassLoader = coreUrlClassLoader = classLoader instanceof UrlClassLoader ? (UrlClassLoader)classLoader : null;
        if (coreUrlClassLoader == null) {
            if (!Boolean.getBoolean("idea.use.core.classloader.for.plugin.path")) {
                ClassLoaderConfiguratorKt.access$getLog().error("You must run JVM with -Djava.system.class.loader=com.intellij.util.lang.PathClassLoader");
            }
            this.setPluginClassLoaderForModuleAndOldSubDescriptors(module, this.coreLoader);
            return null;
        }
        if (coreUrlClassLoader.resolveScopeManager == null) {
            IdeaPluginDescriptorImpl corePlugin = (IdeaPluginDescriptorImpl)CollectionsKt.first(this.pluginSet.enabledPlugins);
            boolean bl = Intrinsics.areEqual((Object)corePlugin.getPluginId(), (Object)PluginManagerCore.CORE_ID);
            if (_Assertions.ENABLED && !bl) {
                String string2 = "Assertion failed";
                throw new AssertionError((Object)string2);
            }
            PluginClassLoader.ResolveScopeManager resolveScopeManager = ClassLoaderConfiguratorKt.access$createPluginDependencyAndContentBasedScope(corePlugin, this.pluginSet);
            if (resolveScopeManager != null) {
                coreUrlClassLoader.resolveScopeManager = (arg_0, arg_1) -> ClassLoaderConfigurator.getCoreUrlClassLoaderIfPossible$lambda$5(resolveScopeManager, arg_0, arg_1);
            }
        }
        return coreUrlClassLoader;
    }

    private final void setPluginClassLoaderForModuleAndOldSubDescriptors(IdeaPluginDescriptorImpl rootDescriptor, ClassLoader classLoader) {
        rootDescriptor.setPluginClassLoader(classLoader);
        for (PluginDependency dependency : rootDescriptor.pluginDependencies) {
            IdeaPluginDescriptorImpl subDescriptor = dependency.subDescriptor;
            if (subDescriptor == null || !this.pluginSet.isPluginEnabled(dependency.getPluginId())) continue;
            this.setPluginClassLoaderForModuleAndOldSubDescriptors(subDescriptor, classLoader);
        }
    }

    private final void checkPackagePrefixUniqueness(IdeaPluginDescriptorImpl module) {
        IdeaPluginDescriptorImpl old;
        String packagePrefix = module.packagePrefix;
        if (packagePrefix != null && (old = this.pluginPackagePrefixUniqueGuard.putIfAbsent(packagePrefix, module)) != null) {
            throw new PluginException("Package prefix " + packagePrefix + " is already used (second=" + module + ", first=" + old + ')', module.getPluginId());
        }
    }

    private final PluginClassLoader createPluginClassLoader(IdeaPluginDescriptorImpl module, IdeaPluginDescriptorImpl[] dependencies, MainInfo mainInfo) {
        PluginClassLoader.ResolveScopeManager resolveScopeManager;
        block15: {
            block13: {
                PluginClassLoader.ResolveScopeManager resolveScopeManager2;
                resolveScopeManager = null;
                if (module.moduleName != null) break block13;
                switch (module.getPluginId().getIdString()) {
                    case "com.intellij.diagram": {
                        resolveScopeManager2 = ClassLoaderConfiguratorKt.access$createScopeWithExtraPackage("com.intellij.diagram.");
                        break;
                    }
                    case "com.intellij.struts2": {
                        resolveScopeManager2 = ClassLoaderConfiguratorKt.access$createScopeWithExtraPackage("com.intellij.lang.ognl.");
                        break;
                    }
                    case "com.intellij.properties": {
                        resolveScopeManager2 = ClassLoaderConfigurator::createPluginClassLoader$lambda$6;
                        break;
                    }
                    default: {
                        resolveScopeManager2 = ClassLoaderConfiguratorKt.access$createPluginDependencyAndContentBasedScope(module, this.pluginSet);
                    }
                }
                resolveScopeManager = resolveScopeManager2;
                break block15;
            }
            resolveScopeManager = module.content.modules.isEmpty() ? ClassLoaderConfiguratorKt.access$createModuleResolveScopeManager() : ClassLoaderConfiguratorKt.access$createModuleContentBasedScope(module);
        }
        return new PluginClassLoader(mainInfo.files, mainInfo.classPath, dependencies, module, this.coreLoader, resolveScopeManager, module.packagePrefix, mainInfo.libDirectories);
    }

    private static final String getCoreUrlClassLoaderIfPossible$lambda$5(PluginClassLoader.ResolveScopeManager $resolveScopeManager, String name2, Boolean force) {
        Intrinsics.checkNotNullExpressionValue((Object)force, (String)"force");
        return $resolveScopeManager.isDefinitelyAlienClass(name2, "", force);
    }

    private static final String createPluginClassLoader$lambda$6(String name2, String packagePrefix, boolean force) {
        String string2;
        if (force) {
            string2 = null;
        } else {
            Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"name");
            Intrinsics.checkNotNullExpressionValue((Object)packagePrefix, (String)"packagePrefix");
            string2 = !StringsKt.startsWith$default((String)name2, (String)packagePrefix, (boolean)false, (int)2, null) && !StringsKt.startsWith$default((String)name2, (String)"com.intellij.ultimate.PluginVerifier", (boolean)false, (int)2, null) && !Intrinsics.areEqual((Object)name2, (Object)"com.intellij.codeInspection.unused.ImplicitPropertyUsageProvider") ? "" : null;
        }
        return string2;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B)\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\u0002\u0010\rR\u0010\u0010\u0005\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/ide/plugins/ClassLoaderConfigurator$MainInfo;", "", "classLoader", "Lcom/intellij/ide/plugins/cl/PluginClassLoader;", "(Lcom/intellij/ide/plugins/cl/PluginClassLoader;)V", "classPath", "Lcom/intellij/util/lang/ClassPath;", "files", "", "Ljava/nio/file/Path;", "libDirectories", "", "", "(Lcom/intellij/util/lang/ClassPath;Ljava/util/List;Ljava/util/List;)V", "intellij.platform.core.impl"})
    private static final class MainInfo {
        @JvmField
        @NotNull
        public final ClassPath classPath;
        @JvmField
        @NotNull
        public final List<Path> files;
        @JvmField
        @NotNull
        public final List<String> libDirectories;

        public MainInfo(@NotNull ClassPath classPath, @NotNull List<? extends Path> files2, @NotNull List<String> libDirectories) {
            Intrinsics.checkNotNullParameter((Object)classPath, (String)"classPath");
            Intrinsics.checkNotNullParameter(files2, (String)"files");
            Intrinsics.checkNotNullParameter(libDirectories, (String)"libDirectories");
            this.classPath = classPath;
            this.files = files2;
            this.libDirectories = libDirectories;
        }

        public MainInfo(@NotNull PluginClassLoader classLoader) {
            Intrinsics.checkNotNullParameter((Object)classLoader, (String)"classLoader");
            ClassPath classPath = classLoader.getClassPath();
            Intrinsics.checkNotNullExpressionValue((Object)classPath, (String)"classLoader.classPath");
            Collection collection = classLoader.getFiles();
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"classLoader.files");
            List<String> list = classLoader.getLibDirectories();
            Intrinsics.checkNotNullExpressionValue(list, (String)"classLoader.libDirectories");
            this(classPath, (List<? extends Path>)collection, list);
        }
    }
}

