/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.execution.process.ProcessIOExecutorService;
import com.intellij.ide.plugins.BundledPluginsState;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.util.BuildNumber;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0007\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lcom/intellij/ide/plugins/BundledPluginsState;", "", "()V", "Companion", "intellij.platform.core.impl"})
@ApiStatus.Internal
public final class BundledPluginsState {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String SAVED_VERSION_KEY = "bundled.plugins.list.saved.version";
    @ApiStatus.Internal
    @NotNull
    public static final String BUNDLED_PLUGINS_FILENAME = "bundled_plugins.txt";
    @NotNull
    private static final Logger LOG;

    public BundledPluginsState() {
        boolean shouldSave;
        PropertiesComponent propertiesComponent = PropertiesComponent.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)propertiesComponent, (String)"getInstance()");
        BuildNumber savedBuildNumber = Companion.getSavedBuildNumber(propertiesComponent);
        BuildNumber buildNumber = ApplicationInfo.getInstance().getBuild();
        Intrinsics.checkNotNullExpressionValue((Object)buildNumber, (String)"getInstance().build");
        BuildNumber currentBuildNumber = buildNumber;
        boolean bl = shouldSave = savedBuildNumber == null || savedBuildNumber.compareTo(currentBuildNumber) < 0 || !ApplicationManager.getApplication().isUnitTestMode() && PluginManagerCore.isRunningFromSources();
        if (shouldSave) {
            Set<IdeaPluginDescriptor> bundledPluginIds = Companion.getLoadedPlugins();
            ProcessIOExecutorService.INSTANCE.execute(() -> BundledPluginsState._init_$lambda$0(bundledPluginIds, currentBuildNumber));
        }
    }

    private static final void _init_$lambda$0(Set $bundledPluginIds, BuildNumber $currentBuildNumber) {
        Intrinsics.checkNotNullParameter((Object)$bundledPluginIds, (String)"$bundledPluginIds");
        Intrinsics.checkNotNullParameter((Object)$currentBuildNumber, (String)"$currentBuildNumber");
        try {
            com.intellij.ide.plugins.BundledPluginsState$Companion.writePluginIdsToFile$default(Companion, $bundledPluginIds, null, 2, null);
            PropertiesComponent propertiesComponent = PropertiesComponent.getInstance();
            Intrinsics.checkNotNullExpressionValue((Object)propertiesComponent, (String)"getInstance()");
            BundledPluginsState.Companion.setSavedBuildNumber(propertiesComponent, $currentBuildNumber);
        }
        catch (IOException e) {
            LOG.warn("Unable to save bundled plugins list", e);
        }
    }

    @JvmStatic
    @NotNull
    public static final Set<Pair<PluginId, String>> readPluginIdsFromFile(@NotNull Path path) {
        return Companion.readPluginIdsFromFile(path);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(BundledPluginsState.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(T::class.java)");
        LOG = logger;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J*\u0010\u0016\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u0018\u0012\n\u0012\b\u0018\u00010\u0004j\u0002`\u00190\u00170\n2\b\b\u0002\u0010\u001a\u001a\u00020\u001bH\u0007J \u0010\u001c\u001a\u00020\u001d2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\b\b\u0002\u0010\u001f\u001a\u00020\u001bH\u0007R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087T\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0005\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n8G\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR,\u0010\u0010\u001a\u0004\u0018\u00010\u000f*\u00020\u00112\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f8G@BX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015\u00a8\u0006 "}, d2={"Lcom/intellij/ide/plugins/BundledPluginsState$Companion;", "", "()V", "BUNDLED_PLUGINS_FILENAME", "", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "SAVED_VERSION_KEY", "loadedPlugins", "", "Lcom/intellij/ide/plugins/IdeaPluginDescriptor;", "getLoadedPlugins", "()Ljava/util/Set;", "value", "Lcom/intellij/openapi/util/BuildNumber;", "savedBuildNumber", "Lcom/intellij/ide/util/PropertiesComponent;", "getSavedBuildNumber", "(Lcom/intellij/ide/util/PropertiesComponent;)Lcom/intellij/openapi/util/BuildNumber;", "setSavedBuildNumber", "(Lcom/intellij/ide/util/PropertiesComponent;Lcom/intellij/openapi/util/BuildNumber;)V", "readPluginIdsFromFile", "Lkotlin/Pair;", "Lcom/intellij/openapi/extensions/PluginId;", "Lcom/intellij/ide/plugins/Category;", "path", "Ljava/nio/file/Path;", "writePluginIdsToFile", "", "pluginIds", "configDir", "intellij.platform.core.impl"})
    public static final class Companion {
        private Companion() {
        }

        @VisibleForTesting
        @Nullable
        public final BuildNumber getSavedBuildNumber(@NotNull PropertiesComponent $this$savedBuildNumber) {
            BuildNumber buildNumber;
            Intrinsics.checkNotNullParameter((Object)$this$savedBuildNumber, (String)"<this>");
            String string2 = $this$savedBuildNumber.getValue(BundledPluginsState.SAVED_VERSION_KEY);
            if (string2 != null) {
                String it = string2;
                boolean bl = false;
                buildNumber = BuildNumber.fromString(it);
            } else {
                buildNumber = null;
            }
            return buildNumber;
        }

        private final void setSavedBuildNumber(PropertiesComponent $this$savedBuildNumber, BuildNumber value) {
            BuildNumber buildNumber = value;
            $this$savedBuildNumber.setValue(BundledPluginsState.SAVED_VERSION_KEY, buildNumber != null ? buildNumber.asString() : null);
        }

        @VisibleForTesting
        @NotNull
        public final Set<IdeaPluginDescriptor> getLoadedPlugins() {
            List<? extends IdeaPluginDescriptor> list = PluginManagerCore.getLoadedPlugins();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getLoadedPlugins()");
            return SequencesKt.toSet((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)list), (Function1)loadedPlugins.1.INSTANCE));
        }

        /*
         * WARNING - void declaration
         */
        @VisibleForTesting
        public final void writePluginIdsToFile(@NotNull Set<? extends IdeaPluginDescriptor> pluginIds, @NotNull Path configDir) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Intrinsics.checkNotNullParameter(pluginIds, (String)"pluginIds");
            Intrinsics.checkNotNullParameter((Object)configDir, (String)"configDir");
            Iterable iterable = pluginIds;
            Path path = configDir.resolve(BundledPluginsState.BUNDLED_PLUGINS_FILENAME);
            boolean $i$f$map = false;
            void var5_6 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                IdeaPluginDescriptor ideaPluginDescriptor = (IdeaPluginDescriptor)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getPluginId().getIdString() + '|' + it.getCategory() + '\n');
            }
            PluginManagerCore.writePluginIdsToFile(path, (List)destination$iv$iv, new OpenOption[0]);
        }

        public static /* synthetic */ void writePluginIdsToFile$default(Companion companion, Set set, Path path, int n, Object object) {
            if ((n & 2) != 0) {
                Path path2 = PathManager.getConfigDir();
                Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"getConfigDir()");
                path = path2;
            }
            companion.writePluginIdsToFile(set, path);
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @NotNull
        public final Set<Pair<PluginId, String>> readPluginIdsFromFile(@NotNull Path path) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Path file2 = path.resolve(BundledPluginsState.BUNDLED_PLUGINS_FILENAME);
            Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"file");
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (!Files.exists(file2, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                return SetsKt.emptySet();
            }
            if (!Files.isRegularFile(file2, new LinkOption[0])) {
                return SetsKt.emptySet();
            }
            Set bundledPlugins = new LinkedHashSet();
            try {
                String it;
                Iterable $this$filterTo$iv$iv;
                Iterable $this$filter$iv;
                Collection collection;
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv;
                Iterable<Path> iterable = file2;
                List<String> list = Files.readAllLines(iterable, Charsets.UTF_8);
                Intrinsics.checkNotNullExpressionValue(list, (String)"readAllLines(this, charset)");
                iterable = list;
                boolean $i$f$map = false;
                void var6_7 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void p0;
                    String string2 = (String)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(((Object)StringsKt.trim((CharSequence)((CharSequence)p0))).toString());
                }
                $this$map$iv = (List)destination$iv$iv;
                boolean $i$f$filter = false;
                $this$mapTo$iv$iv = $this$filter$iv;
                destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    it = (String)element$iv$iv;
                    boolean bl = false;
                    boolean bl2 = !(((CharSequence)it).length() == 0);
                    if (!bl2) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filter$iv = (List)destination$iv$iv;
                $i$f$map = false;
                $this$filterTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    it = (String)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl = false;
                    String[] stringArray = new String[]{"|"};
                    List splitResult = StringsKt.split$default((CharSequence)it, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
                    String id = (String)CollectionsKt.first((List)splitResult);
                    String category = (String)CollectionsKt.getOrNull((List)splitResult, (int)1);
                    collection.add(bundledPlugins.add(new Pair((Object)PluginId.getId(id), (Object)(Intrinsics.areEqual((Object)category, (Object)"null") ? null : category))));
                }
                List cfr_ignored_0 = (List)destination$iv$iv;
            }
            catch (IOException e) {
                LOG.warn("Unable to load bundled plugins list from " + file2, e);
            }
            return bundledPlugins;
        }

        public static /* synthetic */ Set readPluginIdsFromFile$default(Companion companion, Path path, int n, Object object) {
            if ((n & 1) != 0) {
                Path path2 = PathManager.getConfigDir();
                Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"getConfigDir()");
                path = path2;
            }
            return companion.readPluginIdsFromFile(path);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

