/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic;

import com.intellij.diagnostic.InstanceHolder;
import com.intellij.diagnostic.LoadingState;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.util.SystemProperties;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import java.awt.AWTEvent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
@ApiStatus.Internal
public interface EventWatcher {
    public static final boolean isEnabledAggregated = SystemProperties.getBooleanProperty("idea.event.queue.dispatch.report-aggregated-stats-to-otel", true);
    public static final boolean isEnabledDetailed = SystemProperties.getBooleanProperty("idea.event.queue.dispatch.listen", false);

    public static boolean isDetailedWatcherEnabled() {
        return isEnabledDetailed;
    }

    public static boolean isAggregatedWatcherEnabled() {
        return isEnabledAggregated;
    }

    @Nullable
    public static EventWatcher getInstanceOrNull() {
        Application app;
        if (!EventWatcher.isDetailedWatcherEnabled() && !EventWatcher.isAggregatedWatcherEnabled()) {
            return null;
        }
        EventWatcher result2 = InstanceHolder.instance;
        if (result2 == null && LoadingState.CONFIGURATION_STORE_INITIALIZED.isOccurred() && (app = ApplicationManager.getApplication()) != null && !app.isDisposed()) {
            InstanceHolder.instance = result2 = app.getService(EventWatcher.class);
        }
        return result2;
    }

    @RequiresEdt
    public void runnableTaskFinished(@NotNull Runnable var1, long var2, int var4, long var5);

    @RequiresEdt
    public void edtEventStarted(@NotNull AWTEvent var1, long var2);

    @RequiresEdt
    public void edtEventFinished(@NotNull AWTEvent var1, long var2);

    public void reset();

    public void logTimeMillis(@NotNull String var1, long var2, @NotNull Class<? extends Runnable> var4);

    default public void logTimeMillis(@NotNull String processId, long startedAtMs) {
        if (processId == null) {
            EventWatcher.$$$reportNull$$$0(0);
        }
        this.logTimeMillis(processId, startedAtMs, Runnable.class);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processId", "com/intellij/diagnostic/EventWatcher", "logTimeMillis"));
    }
}

