/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.controlflow;

import com.intellij.codeInsight.controlflow.ControlFlow;
import com.intellij.codeInsight.controlflow.Instruction;
import com.intellij.codeInsight.controlflow.TransparentInstruction;
import com.intellij.codeInsight.controlflow.impl.ConditionalInstructionImpl;
import com.intellij.codeInsight.controlflow.impl.ControlFlowImpl;
import com.intellij.codeInsight.controlflow.impl.InstructionImpl;
import com.intellij.codeInsight.controlflow.impl.TransparentInstructionImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ControlFlowBuilder {
    public static final Logger LOG = Logger.getInstance(ControlFlowBuilder.class);
    public List<Instruction> instructions = new ArrayList<Instruction>();
    public Instruction prevInstruction;
    public List<Pair<PsiElement, Instruction>> pending = new ArrayList<Pair<PsiElement, Instruction>>();
    public int instructionCount = 0;
    public int transparentInstructionCount = 0;

    @Nullable
    public Instruction findInstructionByElement(PsiElement element) {
        for (int i = this.instructions.size() - 1; i >= 0; --i) {
            Instruction instruction = this.instructions.get(i);
            if (!element.equals(instruction.getElement())) continue;
            return instruction;
        }
        return null;
    }

    @NotNull
    public final ControlFlow getControlFlow() {
        return new ControlFlowImpl(this.instructions.toArray(Instruction.EMPTY_ARRAY));
    }

    @NotNull
    public final ControlFlow completeControlFlow() {
        if (this.transparentInstructionCount == 0) {
            return this.getControlFlow();
        }
        ArrayList<Instruction> result2 = new ArrayList<Instruction>(this.instructionCount);
        int processedTransparentInstructions = 0;
        for (Instruction instruction : this.instructions) {
            if (instruction instanceof TransparentInstruction) {
                ++processedTransparentInstructions;
                Collection<Instruction> predecessors = instruction.allPred();
                Collection<Instruction> successors = instruction.allSucc();
                for (Instruction predecessor : predecessors) {
                    predecessor.replaceSucc(instruction, successors);
                }
                for (Instruction successor : successors) {
                    successor.replacePred(instruction, predecessors);
                }
                continue;
            }
            result2.add(instruction);
        }
        if (result2.size() != this.instructionCount || processedTransparentInstructions != this.transparentInstructionCount) {
            LOG.error("Control flow graph is inconsistent. Instructions: (" + result2.size() + ", " + this.instructionCount + ")\nTransparent instructions: (" + processedTransparentInstructions + ", " + this.transparentInstructionCount + ")");
        }
        if (!this.pending.isEmpty()) {
            LOG.error("Control flow is used incorrectly. All pending node must be connected to fake exit point. Pending: " + this.pending);
        }
        return new ControlFlowImpl(result2.toArray(Instruction.EMPTY_ARRAY));
    }

    @Deprecated
    @NotNull
    @ApiStatus.ScheduledForRemoval
    public final ControlFlow getCompleteControlFlow() {
        return this.completeControlFlow();
    }

    public void addEdge(@Nullable Instruction beginInstruction, @Nullable Instruction endInstruction) {
        if (beginInstruction == null || endInstruction == null) {
            return;
        }
        beginInstruction.addSucc(endInstruction);
        endInstruction.addPred(beginInstruction);
    }

    public final void addNode(@NotNull Instruction instruction) {
        if (instruction == null) {
            ControlFlowBuilder.$$$reportNull$$$0(0);
        }
        this.instructions.add(instruction);
        if (this.prevInstruction != null) {
            this.addEdge(this.prevInstruction, instruction);
        }
        this.prevInstruction = instruction;
    }

    public final void addNodeAndCheckPending(Instruction instruction) {
        this.addNode(instruction);
        this.checkPending(instruction);
    }

    public final void flowAbrupted() {
        this.prevInstruction = null;
    }

    public void addPendingEdge(@Nullable PsiElement pendingScope, @Nullable Instruction instruction) {
        int i;
        if (instruction == null) {
            return;
        }
        if (pendingScope != null) {
            Pair<PsiElement, Instruction> pair;
            PsiElement scope;
            for (i = 0; i < this.pending.size() && ((scope = (pair = this.pending.get(i)).getFirst()) == null || PsiTreeUtil.isAncestor(scope, pendingScope, true)); ++i) {
            }
        }
        this.pending.add(i, Pair.create(pendingScope, instruction));
    }

    public final void checkPending(@NotNull Instruction instruction) {
        PsiElement element;
        if (instruction == null) {
            ControlFlowBuilder.$$$reportNull$$$0(1);
        }
        if ((element = instruction.getElement()) == null) {
            for (Pair<PsiElement, Instruction> pair : this.pending) {
                this.addEdge(pair.getSecond(), instruction);
            }
            this.pending.clear();
        } else {
            for (int i = this.pending.size() - 1; i >= 0; --i) {
                Pair<PsiElement, Instruction> pair = this.pending.get(i);
                PsiElement scopeWhenToAdd = pair.getFirst();
                if (scopeWhenToAdd == null) continue;
                if (PsiTreeUtil.isAncestor(scopeWhenToAdd, element, false)) break;
                this.addEdge(pair.getSecond(), instruction);
                this.pending.remove(i);
            }
        }
    }

    @NotNull
    public Instruction startNode(@Nullable PsiElement element) {
        InstructionImpl instruction = new InstructionImpl(this, element);
        this.addNodeAndCheckPending(instruction);
        InstructionImpl instructionImpl = instruction;
        if (instructionImpl == null) {
            ControlFlowBuilder.$$$reportNull$$$0(2);
        }
        return instructionImpl;
    }

    @NotNull
    public final TransparentInstruction startTransparentNode(@Nullable PsiElement element, String markerName) {
        TransparentInstructionImpl instruction = new TransparentInstructionImpl(this, element, markerName);
        this.addNodeAndCheckPending(instruction);
        TransparentInstructionImpl transparentInstructionImpl = instruction;
        if (transparentInstructionImpl == null) {
            ControlFlowBuilder.$$$reportNull$$$0(3);
        }
        return transparentInstructionImpl;
    }

    public final Instruction startConditionalNode(PsiElement element, PsiElement condition, boolean result2) {
        ConditionalInstructionImpl instruction = new ConditionalInstructionImpl(this, element, condition, result2);
        this.addNodeAndCheckPending(instruction);
        return instruction;
    }

    @NotNull
    public final ControlFlow build(@NotNull PsiElementVisitor visitor, @NotNull PsiElement element) {
        if (visitor == null) {
            ControlFlowBuilder.$$$reportNull$$$0(4);
        }
        if (element == null) {
            ControlFlowBuilder.$$$reportNull$$$0(5);
        }
        this.visitFor(visitor, element);
        return this.completeControlFlow();
    }

    public final void visitFor(@NotNull PsiElementVisitor visitor, @NotNull PsiElement element) {
        if (visitor == null) {
            ControlFlowBuilder.$$$reportNull$$$0(6);
        }
        if (element == null) {
            ControlFlowBuilder.$$$reportNull$$$0(7);
        }
        this.addEntryPointNode(element);
        element.acceptChildren(visitor);
        Instruction exitInstruction = this.startNode(null);
        this.checkPending(exitInstruction);
    }

    protected void addEntryPointNode(PsiElement startElement) {
        this.startNode(null);
    }

    public final void updatePendingElementScope(@NotNull PsiElement parentForScope, @Nullable PsiElement newParentScope) {
        if (parentForScope == null) {
            ControlFlowBuilder.$$$reportNull$$$0(8);
        }
        this.processPending((pendingScope, instruction) -> {
            if (pendingScope != null && PsiTreeUtil.isAncestor(parentForScope, pendingScope, false)) {
                this.addPendingEdge(newParentScope, instruction);
            } else {
                this.addPendingEdge(pendingScope, instruction);
            }
        });
    }

    public void processPending(@NotNull PendingProcessor processor) {
        if (processor == null) {
            ControlFlowBuilder.$$$reportNull$$$0(9);
        }
        List<Pair<PsiElement, Instruction>> pending = this.pending;
        this.pending = new ArrayList<Pair<PsiElement, Instruction>>();
        for (Pair<PsiElement, Instruction> pair : pending) {
            processor.process(pair.getFirst(), pair.getSecond());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instruction";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/controlflow/ControlFlowBuilder";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentForScope";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/controlflow/ControlFlowBuilder";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "startNode";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "startTransparentNode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addNode";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "checkPending";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "build";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "visitFor";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "updatePendingElementScope";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "processPending";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    @FunctionalInterface
    public static interface PendingProcessor {
        public void process(@Nullable PsiElement var1, @NotNull Instruction var2);
    }
}

