/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight;

import com.intellij.codeInsight.ExternalAnnotationsManager;
import com.intellij.lang.java.parser.JavaParser;
import com.intellij.lang.java.parser.JavaParserUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.LowMemoryWatcher;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.impl.source.CharTableImpl;
import com.intellij.psi.impl.source.DummyHolder;
import com.intellij.psi.impl.source.DummyHolderFactory;
import com.intellij.psi.impl.source.JavaDummyElement;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.SmartList;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ConcurrentMostlySingularMultiMap;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MostlySingularMultiMap;
import com.intellij.util.text.CharSequenceReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public abstract class BaseExternalAnnotationsManager
extends ExternalAnnotationsManager {
    private static final Logger LOG = Logger.getInstance(BaseExternalAnnotationsManager.class);
    private static final Key<Boolean> EXTERNAL_ANNO_MARKER = Key.create("EXTERNAL_ANNO_MARKER");
    private static final List<PsiFile> NULL_LIST = Collections.emptyList();
    protected final PsiManager myPsiManager;
    private final Map<Object, List<PsiFile>> myExternalAnnotationsCache;
    private final Map<AnnotationData, AnnotationData> myAnnotationDataCache;
    private final Map<PsiFile, Pair<MostlySingularMultiMap<String, AnnotationData>, Long>> myAnnotationFileToDataAndModStampCache;
    private static final List<AnnotationData> NO_DATA = new ArrayList<AnnotationData>(1);
    private final ConcurrentMostlySingularMultiMap<Object, AnnotationData> cache;
    private final CharTableImpl charTable;

    public BaseExternalAnnotationsManager(@NotNull PsiManager psiManager) {
        if (psiManager == null) {
            BaseExternalAnnotationsManager.$$$reportNull$$$0(0);
        }
        this.myExternalAnnotationsCache = ContainerUtil.createConcurrentWeakKeySoftValueMap();
        this.myAnnotationDataCache = ContainerUtil.createWeakKeyWeakValueMap();
        this.myAnnotationFileToDataAndModStampCache = CollectionFactory.createConcurrentSoftMap();
        this.cache = new ConcurrentMostlySingularMultiMap();
        this.charTable = new CharTableImpl();
        this.myPsiManager = psiManager;
        LowMemoryWatcher.register(this::dropCache, psiManager.getProject());
    }

    @Nullable
    protected static String getExternalName(@NotNull PsiModifierListOwner listOwner) {
        if (listOwner == null) {
            BaseExternalAnnotationsManager.$$$reportNull$$$0(1);
        }
        return PsiFormatUtil.getExternalName(listOwner, false, Integer.MAX_VALUE);
    }

    protected abstract boolean hasAnyAnnotationsRoots();

    @Override
    public boolean hasAnnotationRootsForFile(@NotNull VirtualFile file2) {
        if (file2 == null) {
            BaseExternalAnnotationsManager.$$$reportNull$$$0(2);
        }
        return this.hasAnyAnnotationsRoots();
    }

    @Override
    public boolean isExternalAnnotation(@NotNull PsiAnnotation annotation) {
        if (annotation == null) {
            BaseExternalAnnotationsManager.$$$reportNull$$$0(3);
        }
        return annotation.getUserData(EXTERNAL_ANNO_MARKER) != null;
    }

    @Override
    @Nullable
    public PsiAnnotation findExternalAnnotation(@NotNull PsiModifierListOwner listOwner, @NotNull String annotationFQN) {
        List<PsiAnnotation> result2;
        if (listOwner == null) {
            BaseExternalAnnotationsManager.$$$reportNull$$$0(4);
        }
        if (annotationFQN == null) {
            BaseExternalAnnotationsManager.$$$reportNull$$$0(5);
        }
        return (result2 = this.findExternalAnnotations(listOwner, annotationFQN)).isEmpty() ? null : result2.get(0);
    }

    @Override
    @NotNull
    public List<PsiAnnotation> findExternalAnnotations(@NotNull PsiModifierListOwner listOwner, @NotNull String annotationFQN) {
        if (listOwner == null) {
            BaseExternalAnnotationsManager.$$$reportNull$$$0(6);
        }
        if (annotationFQN == null) {
            BaseExternalAnnotationsManager.$$$reportNull$$$0(7);
        }
        List<AnnotationData> result2 = this.collectExternalAnnotations(listOwner);
        return this.filterAnnotations(result2, annotationFQN);
    }

    @Override
    @Nullable
    public List<PsiAnnotation> findDefaultConstructorExternalAnnotations(@NotNull PsiClass aClass, @NotNull String annotationFQN) {
        if (aClass == null) {
            BaseExternalAnnotationsManager.$$$reportNull$$$0(8);
        }
        if (annotationFQN == null) {
            BaseExternalAnnotationsManager.$$$reportNull$$$0(9);
        }
        if (aClass.getConstructors().length > 0) {
            return null;
        }
        List<AnnotationData> result2 = this.collectDefaultConstructorExternalAnnotations(aClass);
        return this.filterAnnotations(result2, annotationFQN);
    }

    @NotNull
    private List<PsiAnnotation> filterAnnotations(@NotNull List<AnnotationData> result2, @NotNull String annotationFQN) {
        if (result2 == null) {
            BaseExternalAnnotationsManager.$$$reportNull$$$0(10);
        }
        if (annotationFQN == null) {
            BaseExternalAnnotationsManager.$$$reportNull$$$0(11);
        }
        SmartList<PsiAnnotation> annotations = new SmartList<PsiAnnotation>();
        for (AnnotationData data : result2) {
            if (!data.annotationClassFqName.equals(annotationFQN)) continue;
            PsiAnnotation annotation = data.getAnnotation(this);
            annotations.add(annotation);
        }
        SmartList<PsiAnnotation> smartList = annotations;
        if (smartList == null) {
            BaseExternalAnnotationsManager.$$$reportNull$$$0(12);
        }
        return smartList;
    }

    @Override
    @Nullable
    public List<PsiAnnotation> findDefaultConstructorExternalAnnotations(@NotNull PsiClass aClass) {
        if (aClass == null) {
            BaseExternalAnnotationsManager.$$$reportNull$$$0(13);
        }
        if (aClass.getConstructors().length > 0) {
            return null;
        }
        List<AnnotationData> result2 = this.collectDefaultConstructorExternalAnnotations(aClass);
        return ContainerUtil.map(result2, data -> data.getAnnotation(this));
    }

    @Override
    public boolean isExternalAnnotationWritable(@NotNull PsiModifierListOwner listOwner, @NotNull String annotationFQN) {
        List<AnnotationData> map2;
        if (listOwner == null) {
            BaseExternalAnnotationsManager.$$$reportNull$$$0(14);
        }
        if (annotationFQN == null) {
            BaseExternalAnnotationsManager.$$$reportNull$$$0(15);
        }
        return BaseExternalAnnotationsManager.findByFQN(map2 = this.doCollect(listOwner, true), annotationFQN) != null;
    }

    private static AnnotationData findByFQN(@NotNull List<AnnotationData> map2, @NotNull String annotationFQN) {
        if (map2 == null) {
            BaseExternalAnnotationsManager.$$$reportNull$$$0(16);
        }
        if (annotationFQN == null) {
            BaseExternalAnnotationsManager.$$$reportNull$$$0(17);
        }
        return (AnnotationData)((Object)ContainerUtil.find(map2, data -> ((AnnotationData)data).annotationClassFqName.equals(annotationFQN)));
    }

    @Override
    public PsiAnnotation @Nullable [] findExternalAnnotations(@NotNull PsiModifierListOwner listOwner) {
        List<AnnotationData> result2;
        if (listOwner == null) {
            BaseExternalAnnotationsManager.$$$reportNull$$$0(18);
        }
        return (result2 = this.collectExternalAnnotations(listOwner)).isEmpty() ? null : ContainerUtil.map2Array(result2, PsiAnnotation.EMPTY_ARRAY, data -> data.getAnnotation(this));
    }

    @NotNull
    private List<AnnotationData> collectDefaultConstructorExternalAnnotations(@NotNull PsiClass aClass) {
        List<PsiFile> annotationsFiles;
        if (aClass == null) {
            BaseExternalAnnotationsManager.$$$reportNull$$$0(19);
        }
        if ((annotationsFiles = this.findExternalAnnotationsFiles(aClass)) == null) {
            List<AnnotationData> list = NO_DATA;
            if (list == null) {
                BaseExternalAnnotationsManager.$$$reportNull$$$0(20);
            }
            return list;
        }
        String defCtrExternalName = BaseExternalAnnotationsManager.getExternalName(aClass) + " " + aClass.getName() + "()";
        return this.collectExternalAnnotations(defCtrExternalName, () -> this.doCollect(defCtrExternalName, annotationsFiles, false));
    }

    @NotNull
    private List<AnnotationData> collectExternalAnnotations(@NotNull PsiModifierListOwner listOwner) {
        if (listOwner == null) {
            BaseExternalAnnotationsManager.$$$reportNull$$$0(21);
        }
        return this.collectExternalAnnotations(listOwner, () -> this.doCollect(listOwner, false));
    }

    @NotNull
    private List<AnnotationData> collectExternalAnnotations(@NotNull Object cacheKey, @NotNull Supplier<? extends List<AnnotationData>> dataSupplier) {
        List<AnnotationData> computed;
        List<AnnotationData> cached;
        if (cacheKey == null) {
            BaseExternalAnnotationsManager.$$$reportNull$$$0(22);
        }
        if (dataSupplier == null) {
            BaseExternalAnnotationsManager.$$$reportNull$$$0(23);
        }
        if (!this.hasAnyAnnotationsRoots()) {
            List<AnnotationData> list = Collections.emptyList();
            if (list == null) {
                BaseExternalAnnotationsManager.$$$reportNull$$$0(24);
            }
            return list;
        }
        do {
            if ((cached = (List<AnnotationData>)this.cache.get(cacheKey)) != NO_DATA && cached.isEmpty()) continue;
            List<AnnotationData> list = cached;
            if (list == null) {
                BaseExternalAnnotationsManager.$$$reportNull$$$0(25);
            }
            return list;
        } while (!this.cache.replace(cacheKey, (Collection<AnnotationData>)cached, computed = dataSupplier.get()));
        cached = computed;
        List<AnnotationData> list = cached;
        if (list == null) {
            BaseExternalAnnotationsManager.$$$reportNull$$$0(26);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    private AnnotationData internAnnotationData(@NotNull AnnotationData data) {
        if (data == null) {
            BaseExternalAnnotationsManager.$$$reportNull$$$0(27);
        }
        Map<AnnotationData, AnnotationData> map2 = this.myAnnotationDataCache;
        // MONITORENTER : map2
        AnnotationData interned = this.myAnnotationDataCache.get(data);
        if (interned == null) {
            this.myAnnotationDataCache.put(data, data);
            interned = data;
        }
        AnnotationData annotationData = interned;
        // MONITOREXIT : map2
        if (annotationData != null) return annotationData;
        BaseExternalAnnotationsManager.$$$reportNull$$$0(28);
        return annotationData;
    }

    @NotNull
    public MostlySingularMultiMap<String, AnnotationData> getDataFromFile(@NotNull PsiFile file2) {
        if (file2 == null) {
            BaseExternalAnnotationsManager.$$$reportNull$$$0(29);
        }
        Pair<MostlySingularMultiMap<String, AnnotationData>, Long> cached = this.myAnnotationFileToDataAndModStampCache.get(file2);
        long fileModificationStamp = file2.getModificationStamp();
        if (cached != null && cached.getSecond() == fileModificationStamp) {
            MostlySingularMultiMap<String, AnnotationData> mostlySingularMultiMap = cached.getFirst();
            if (mostlySingularMultiMap == null) {
                BaseExternalAnnotationsManager.$$$reportNull$$$0(30);
            }
            return mostlySingularMultiMap;
        }
        MostlySingularMultiMap<String, AnnotationData> result2 = BaseExternalAnnotationsManager.loadData(file2.getViewProvider().getVirtualFile(), file2.getViewProvider().getContents(), this);
        this.myAnnotationFileToDataAndModStampCache.put(file2, Pair.create(result2, fileModificationStamp));
        MostlySingularMultiMap<String, AnnotationData> mostlySingularMultiMap = result2;
        if (mostlySingularMultiMap == null) {
            BaseExternalAnnotationsManager.$$$reportNull$$$0(31);
        }
        return mostlySingularMultiMap;
    }

    @NotNull
    public static MostlySingularMultiMap<String, AnnotationData> loadData(@NotNull VirtualFile virtualFile, @NotNull CharSequence fileText, @Nullable BaseExternalAnnotationsManager externalAnnotationsManager) {
        if (virtualFile == null) {
            BaseExternalAnnotationsManager.$$$reportNull$$$0(32);
        }
        if (fileText == null) {
            BaseExternalAnnotationsManager.$$$reportNull$$$0(33);
        }
        DataParsingSaxHandler handler = new DataParsingSaxHandler(virtualFile, externalAnnotationsManager);
        try {
            SAXParser saxParser = Holder.FACTORY.newSAXParser();
            saxParser.parse(new InputSource(new CharSequenceReader(BaseExternalAnnotationsManager.escapeAttributes(fileText))), (DefaultHandler)handler);
        }
        catch (SAXParseException e) {
            if (externalAnnotationsManager != null) {
                externalAnnotationsManager.reportXmlParseError(virtualFile, e);
            } else {
                LOG.error(virtualFile.getPath(), e);
            }
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            LOG.error(virtualFile.getPath(), e);
        }
        MostlySingularMultiMap<String, AnnotationData> mostlySingularMultiMap = handler.getResult();
        if (mostlySingularMultiMap == null) {
            BaseExternalAnnotationsManager.$$$reportNull$$$0(34);
        }
        return mostlySingularMultiMap;
    }

    protected void reportXmlParseError(@NotNull VirtualFile file2, @NotNull SAXParseException exception) {
        if (file2 == null) {
            BaseExternalAnnotationsManager.$$$reportNull$$$0(35);
        }
        if (exception == null) {
            BaseExternalAnnotationsManager.$$$reportNull$$$0(36);
        }
        LOG.error(file2.getPath(), exception);
    }

    protected void duplicateError(@NotNull VirtualFile virtualFile, @NotNull String externalName, @NotNull String text) {
        if (virtualFile == null) {
            BaseExternalAnnotationsManager.$$$reportNull$$$0(37);
        }
        if (externalName == null) {
            BaseExternalAnnotationsManager.$$$reportNull$$$0(38);
        }
        if (text == null) {
            BaseExternalAnnotationsManager.$$$reportNull$$$0(39);
        }
        LOG.error(text + "; for signature: '" + externalName + "' in the " + virtualFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    private String intern(@NotNull String annotationFQN) {
        if (annotationFQN == null) {
            BaseExternalAnnotationsManager.$$$reportNull$$$0(40);
        }
        CharTableImpl charTableImpl = this.charTable;
        // MONITORENTER : charTableImpl
        String string2 = this.charTable.doIntern(annotationFQN).toString();
        // MONITOREXIT : charTableImpl
        if (string2 != null) return string2;
        BaseExternalAnnotationsManager.$$$reportNull$$$0(41);
        return string2;
    }

    @NotNull
    private List<AnnotationData> doCollect(@NotNull PsiModifierListOwner listOwner, boolean onlyWritable) {
        List<PsiFile> files2;
        if (listOwner == null) {
            BaseExternalAnnotationsManager.$$$reportNull$$$0(42);
        }
        if ((files2 = this.findExternalAnnotationsFiles(listOwner)) == null) {
            List<AnnotationData> list = NO_DATA;
            if (list == null) {
                BaseExternalAnnotationsManager.$$$reportNull$$$0(43);
            }
            return list;
        }
        String externalName = BaseExternalAnnotationsManager.getExternalName(listOwner);
        if (externalName == null) {
            List<AnnotationData> list = NO_DATA;
            if (list == null) {
                BaseExternalAnnotationsManager.$$$reportNull$$$0(44);
            }
            return list;
        }
        return this.doCollect(externalName, files2, onlyWritable);
    }

    @NotNull
    private List<AnnotationData> doCollect(@NotNull String externalName, @NotNull List<? extends PsiFile> annotationsFiles, boolean onlyWritable) {
        if (externalName == null) {
            BaseExternalAnnotationsManager.$$$reportNull$$$0(45);
        }
        if (annotationsFiles == null) {
            BaseExternalAnnotationsManager.$$$reportNull$$$0(46);
        }
        SmartList<AnnotationData> result2 = new SmartList<AnnotationData>();
        for (PsiFile psiFile : annotationsFiles) {
            if (!psiFile.isValid() || onlyWritable && !psiFile.isWritable()) continue;
            MostlySingularMultiMap<String, AnnotationData> fileData = this.getDataFromFile(psiFile);
            ContainerUtil.addAll(result2, fileData.get(externalName));
        }
        if (result2.isEmpty()) {
            List<AnnotationData> list = NO_DATA;
            if (list == null) {
                BaseExternalAnnotationsManager.$$$reportNull$$$0(47);
            }
            return list;
        }
        result2.trimToSize();
        SmartList<AnnotationData> smartList = result2;
        if (smartList == null) {
            BaseExternalAnnotationsManager.$$$reportNull$$$0(48);
        }
        return smartList;
    }

    @Override
    @Nullable
    public List<PsiFile> findExternalAnnotationsFiles(@NotNull PsiModifierListOwner listOwner) {
        if (listOwner == null) {
            BaseExternalAnnotationsManager.$$$reportNull$$$0(49);
        }
        if (listOwner instanceof PsiPackage) {
            String packageName = ((PsiPackage)listOwner).getQualifiedName();
            Function<PsiPackage, List> roots = pack -> Arrays.stream(pack.getDirectories()).flatMap(dir -> this.getExternalAnnotationsRoots(dir.getVirtualFile()).stream()).distinct().collect(Collectors.toList());
            return this.findExternalAnnotationsFiles(packageName, (PsiPackage)listOwner, roots);
        }
        PsiFile containingFile = PsiUtil.preferCompiledElement(listOwner).getContainingFile();
        if (!(containingFile instanceof PsiClassOwner)) {
            return null;
        }
        VirtualFile virtualFile = containingFile.getVirtualFile();
        if (virtualFile == null || !virtualFile.isValid()) {
            return null;
        }
        return this.findExternalAnnotationsFiles(((PsiClassOwner)containingFile).getPackageName(), virtualFile, f -> this.getExternalAnnotationsRoots((VirtualFile)f));
    }

    private <T> List<PsiFile> findExternalAnnotationsFiles(String packageName, @NotNull T key, @NotNull Function<? super T, ? extends List<VirtualFile>> rootGetter) {
        List<PsiFile> files2;
        if (key == null) {
            BaseExternalAnnotationsManager.$$$reportNull$$$0(50);
        }
        if (rootGetter == null) {
            BaseExternalAnnotationsManager.$$$reportNull$$$0(51);
        }
        if ((files2 = this.myExternalAnnotationsCache.get(key)) == NULL_LIST) {
            return null;
        }
        if (files2 != null) {
            boolean allValid = true;
            for (PsiFile psiFile : files2) {
                if (psiFile.isValid()) continue;
                allValid = false;
                break;
            }
            if (allValid) {
                return files2;
            }
        }
        HashSet<PsiFile> possibleAnnotationXmls = new HashSet<PsiFile>();
        String relativePath = packageName.replace('.', '/') + '/' + "annotations.xml";
        for (VirtualFile root : rootGetter.apply(key)) {
            PsiFile psiFile;
            VirtualFile ext = root.findFileByRelativePath(relativePath);
            if (ext == null || !ext.isValid() || (psiFile = this.myPsiManager.findFile(ext)) == null) continue;
            possibleAnnotationXmls.add(psiFile);
        }
        if (possibleAnnotationXmls.isEmpty()) {
            this.myExternalAnnotationsCache.put(key, NULL_LIST);
            return null;
        }
        ArrayList<PsiFile> arrayList = new ArrayList<PsiFile>(possibleAnnotationXmls);
        arrayList.sort((f1, f2) -> {
            boolean w2;
            boolean w1 = f1.isWritable();
            return w1 == (w2 = f2.isWritable()) ? 0 : (w1 ? -1 : 1);
        });
        this.myExternalAnnotationsCache.put(key, arrayList);
        return arrayList;
    }

    @NotNull
    protected abstract List<VirtualFile> getExternalAnnotationsRoots(@NotNull VirtualFile var1);

    protected void dropCache() {
        this.myExternalAnnotationsCache.clear();
        this.myAnnotationFileToDataAndModStampCache.clear();
        this.cache.clear();
    }

    @NotNull
    private static CharSequence escapeAttributes(@NotNull CharSequence invalidXml) {
        if (invalidXml == null) {
            BaseExternalAnnotationsManager.$$$reportNull$$$0(52);
        }
        if (!BaseExternalAnnotationsManager.hasInvalidAttribute(invalidXml)) {
            CharSequence charSequence = invalidXml;
            if (charSequence == null) {
                BaseExternalAnnotationsManager.$$$reportNull$$$0(53);
            }
            return charSequence;
        }
        StringBuilder buf = new StringBuilder(invalidXml.length());
        boolean inAttribute = false;
        for (int i = 0; i < invalidXml.length(); ++i) {
            char c = invalidXml.charAt(i);
            if (inAttribute && c == '<') {
                buf.append("&lt;");
                continue;
            }
            if (inAttribute && c == '>') {
                buf.append("&gt;");
                continue;
            }
            if (c == '\"' || c == '\'') {
                buf.append('\"');
                inAttribute = !inAttribute;
                continue;
            }
            buf.append(c);
        }
        StringBuilder stringBuilder = buf;
        if (stringBuilder == null) {
            BaseExternalAnnotationsManager.$$$reportNull$$$0(54);
        }
        return stringBuilder;
    }

    private static boolean hasInvalidAttribute(@NotNull CharSequence invalidXml) {
        if (invalidXml == null) {
            BaseExternalAnnotationsManager.$$$reportNull$$$0(55);
        }
        boolean inAttribute = false;
        for (int i = 0; i < invalidXml.length(); ++i) {
            char c = invalidXml.charAt(i);
            if (inAttribute && c == '<') {
                return true;
            }
            if (inAttribute && c == '>') {
                return true;
            }
            if (c != '\"' && c != '\'') continue;
            inAttribute = !inAttribute;
        }
        return false;
    }

    @Override
    public void annotateExternally(@NotNull PsiModifierListOwner listOwner, @NotNull String annotationFQName, @NotNull PsiFile fromFile, PsiNameValuePair @Nullable [] value) throws ExternalAnnotationsManager.CanceledConfigurationException {
        if (listOwner == null) {
            BaseExternalAnnotationsManager.$$$reportNull$$$0(56);
        }
        if (annotationFQName == null) {
            BaseExternalAnnotationsManager.$$$reportNull$$$0(57);
        }
        if (fromFile == null) {
            BaseExternalAnnotationsManager.$$$reportNull$$$0(58);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean deannotate(@NotNull PsiModifierListOwner listOwner, @NotNull String annotationFQN) {
        if (listOwner == null) {
            BaseExternalAnnotationsManager.$$$reportNull$$$0(59);
        }
        if (annotationFQN == null) {
            BaseExternalAnnotationsManager.$$$reportNull$$$0(60);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean editExternalAnnotation(@NotNull PsiModifierListOwner listOwner, @NotNull String annotationFQN, PsiNameValuePair @Nullable [] value) {
        if (listOwner == null) {
            BaseExternalAnnotationsManager.$$$reportNull$$$0(61);
        }
        if (annotationFQN == null) {
            BaseExternalAnnotationsManager.$$$reportNull$$$0(62);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public ExternalAnnotationsManager.AnnotationPlace chooseAnnotationsPlaceNoUi(@NotNull PsiElement element) {
        if (element == null) {
            BaseExternalAnnotationsManager.$$$reportNull$$$0(63);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public ExternalAnnotationsManager.AnnotationPlace chooseAnnotationsPlace(@NotNull PsiElement element) {
        if (element == null) {
            BaseExternalAnnotationsManager.$$$reportNull$$$0(64);
        }
        throw new UnsupportedOperationException();
    }

    protected void registerExternalAnnotations(@NotNull Object key, @NotNull PsiFile annotationsFile) {
        if (key == null) {
            BaseExternalAnnotationsManager.$$$reportNull$$$0(65);
        }
        if (annotationsFile == null) {
            BaseExternalAnnotationsManager.$$$reportNull$$$0(66);
        }
        this.myExternalAnnotationsCache.compute(key, (k, v) -> {
            if (v == null || v == NULL_LIST) {
                return new SmartList<PsiFile>(annotationsFile);
            }
            v.add(annotationsFile);
            return v;
        });
    }

    private static PsiAnnotation markAsExternalAnnotation(@NotNull PsiAnnotation annotation) {
        if (annotation == null) {
            BaseExternalAnnotationsManager.$$$reportNull$$$0(67);
        }
        annotation.putUserData(EXTERNAL_ANNO_MARKER, Boolean.TRUE);
        ((LightVirtualFile)annotation.getContainingFile().getViewProvider().getVirtualFile()).setWritable(false);
        return annotation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    private PsiAnnotation createAnnotationFromText(@NotNull String text) throws IncorrectOperationException {
        if (text == null) {
            BaseExternalAnnotationsManager.$$$reportNull$$$0(68);
        }
        JavaParserUtil.ParserWrapper ANNOTATION = JavaParser.INSTANCE.getDeclarationParser()::parseAnnotation;
        CharTableImpl charTableImpl = this.charTable;
        // MONITORENTER : charTableImpl
        DummyHolder holder = DummyHolderFactory.createHolder(this.myPsiManager, new JavaDummyElement(text, ANNOTATION, LanguageLevel.HIGHEST), null, this.charTable);
        PsiElement element = SourceTreeToPsiMap.treeElementToPsi(holder.getTreeElement().getFirstChildNode());
        if (!(element instanceof PsiAnnotation)) {
            throw new IncorrectOperationException("Incorrect annotation \"" + text + "\".");
        }
        PsiAnnotation psiAnnotation = BaseExternalAnnotationsManager.markAsExternalAnnotation((PsiAnnotation)element);
        // MONITOREXIT : charTableImpl
        if (psiAnnotation != null) return psiAnnotation;
        BaseExternalAnnotationsManager.$$$reportNull$$$0(69);
        return psiAnnotation;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 12: 
            case 20: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 30: 
            case 31: 
            case 34: 
            case 41: 
            case 43: 
            case 44: 
            case 47: 
            case 48: 
            case 53: 
            case 54: 
            case 69: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 12: 
            case 20: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 30: 
            case 31: 
            case 34: 
            case 41: 
            case 43: 
            case 44: 
            case 47: 
            case 48: 
            case 53: 
            case 54: 
            case 69: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiManager";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 14: 
            case 18: 
            case 21: 
            case 42: 
            case 49: 
            case 56: 
            case 59: 
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listOwner";
                break;
            }
            case 2: 
            case 29: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotation";
                break;
            }
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 15: 
            case 17: 
            case 40: 
            case 60: 
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotationFQN";
                break;
            }
            case 8: 
            case 13: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 12: 
            case 20: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 30: 
            case 31: 
            case 34: 
            case 41: 
            case 43: 
            case 44: 
            case 47: 
            case 48: 
            case 53: 
            case 54: 
            case 69: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/BaseExternalAnnotationsManager";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cacheKey";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSupplier";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 32: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileText";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exception";
                break;
            }
            case 38: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalName";
                break;
            }
            case 39: 
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotationsFiles";
                break;
            }
            case 50: 
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootGetter";
                break;
            }
            case 52: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "invalidXml";
                break;
            }
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotationFQName";
                break;
            }
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fromFile";
                break;
            }
            case 63: 
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotationsFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/BaseExternalAnnotationsManager";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "filterAnnotations";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "collectDefaultConstructorExternalAnnotations";
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "collectExternalAnnotations";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "internAnnotationData";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataFromFile";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "loadData";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "intern";
                break;
            }
            case 43: 
            case 44: 
            case 47: 
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "doCollect";
                break;
            }
            case 53: 
            case 54: {
                objectArray = objectArray2;
                objectArray2[1] = "escapeAttributes";
                break;
            }
            case 69: {
                objectArray = objectArray2;
                objectArray2[1] = "createAnnotationFromText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getExternalName";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "hasAnnotationRootsForFile";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isExternalAnnotation";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findExternalAnnotation";
                break;
            }
            case 6: 
            case 7: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "findExternalAnnotations";
                break;
            }
            case 8: 
            case 9: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "findDefaultConstructorExternalAnnotations";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "filterAnnotations";
                break;
            }
            case 12: 
            case 20: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 30: 
            case 31: 
            case 34: 
            case 41: 
            case 43: 
            case 44: 
            case 47: 
            case 48: 
            case 53: 
            case 54: 
            case 69: {
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isExternalAnnotationWritable";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "findByFQN";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "collectDefaultConstructorExternalAnnotations";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "collectExternalAnnotations";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "internAnnotationData";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getDataFromFile";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "loadData";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "reportXmlParseError";
                break;
            }
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "duplicateError";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "intern";
                break;
            }
            case 42: 
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "doCollect";
                break;
            }
            case 49: 
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "findExternalAnnotationsFiles";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "escapeAttributes";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "hasInvalidAttribute";
                break;
            }
            case 56: 
            case 57: 
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "annotateExternally";
                break;
            }
            case 59: 
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "deannotate";
                break;
            }
            case 61: 
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "editExternalAnnotation";
                break;
            }
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "chooseAnnotationsPlaceNoUi";
                break;
            }
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "chooseAnnotationsPlace";
                break;
            }
            case 65: 
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "registerExternalAnnotations";
                break;
            }
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "markAsExternalAnnotation";
                break;
            }
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "createAnnotationFromText";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 12: 
            case 20: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 30: 
            case 31: 
            case 34: 
            case 41: 
            case 43: 
            case 44: 
            case 47: 
            case 48: 
            case 53: 
            case 54: 
            case 69: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    public static final class AnnotationData {
        private final String annotationClassFqName;
        private final String annotationParameters;
        private volatile PsiAnnotation myAnnotation;

        private AnnotationData(@NotNull String fqn, @NotNull String parameters) {
            if (fqn == null) {
                AnnotationData.$$$reportNull$$$0(0);
            }
            if (parameters == null) {
                AnnotationData.$$$reportNull$$$0(1);
            }
            this.annotationClassFqName = fqn;
            this.annotationParameters = parameters;
        }

        @NotNull
        public PsiAnnotation getAnnotation(@NotNull BaseExternalAnnotationsManager context2) {
            PsiAnnotation a;
            if (context2 == null) {
                AnnotationData.$$$reportNull$$$0(2);
            }
            if ((a = this.myAnnotation) == null) {
                String text = "@" + this.annotationClassFqName + (this.annotationParameters.isEmpty() ? "" : "(" + this.annotationParameters + ")");
                this.myAnnotation = a = context2.createAnnotationFromText(text);
            }
            PsiAnnotation psiAnnotation = a;
            if (psiAnnotation == null) {
                AnnotationData.$$$reportNull$$$0(3);
            }
            return psiAnnotation;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AnnotationData data = (AnnotationData)o;
            return this.annotationClassFqName.equals(data.annotationClassFqName) && this.annotationParameters.equals(data.annotationParameters);
        }

        public int hashCode() {
            int result2 = this.annotationClassFqName.hashCode();
            result2 = 31 * result2 + this.annotationParameters.hashCode();
            return result2;
        }

        public String toString() {
            return this.annotationClassFqName + "(" + this.annotationParameters + ")";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fqn";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parameters";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInsight/BaseExternalAnnotationsManager$AnnotationData";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInsight/BaseExternalAnnotationsManager$AnnotationData";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAnnotation";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getAnnotation";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static final class DataParsingSaxHandler
    extends DefaultHandler {
        private final MostlySingularMultiMap<String, AnnotationData> myData;
        @NotNull
        private final VirtualFile myFile;
        private final BaseExternalAnnotationsManager myExternalAnnotationsManager;
        private String myExternalName;
        private String myAnnotationFqn;
        private StringBuilder myArguments;

        private DataParsingSaxHandler(@NotNull VirtualFile file2, @Nullable BaseExternalAnnotationsManager manager) {
            if (file2 == null) {
                DataParsingSaxHandler.$$$reportNull$$$0(0);
            }
            this.myData = new MostlySingularMultiMap();
            this.myFile = file2;
            this.myExternalAnnotationsManager = manager;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) {
            if ("item".equals(qName)) {
                this.myExternalName = attributes.getValue("name");
            } else if ("annotation".equals(qName)) {
                this.myAnnotationFqn = attributes.getValue("name");
                this.myArguments = new StringBuilder();
            } else if ("val".equals(qName)) {
                String name2;
                if (this.myArguments.length() != 0) {
                    this.myArguments.append(",");
                }
                if ((name2 = attributes.getValue("name")) != null) {
                    this.myArguments.append(name2);
                    this.myArguments.append("=");
                }
                this.myArguments.append(attributes.getValue("val"));
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) {
            if ("item".equals(qName)) {
                this.myExternalName = null;
            } else if ("annotation".equals(qName) && this.myExternalName != null && this.myAnnotationFqn != null) {
                for (AnnotationData existingData : this.myData.get(this.myExternalName)) {
                    if (!existingData.annotationClassFqName.equals(this.myAnnotationFqn) || this.myExternalAnnotationsManager == null) continue;
                    this.myExternalAnnotationsManager.duplicateError(this.myFile, this.myExternalName, "Duplicate annotation '" + this.myAnnotationFqn + "'");
                }
                String argumentsString = this.myArguments.length() == 0 ? "" : (this.myExternalAnnotationsManager == null ? this.myArguments.toString() : this.myExternalAnnotationsManager.intern(this.myArguments.toString()));
                AnnotationData data = new AnnotationData(this.myAnnotationFqn, argumentsString);
                this.myData.add(this.myExternalName, this.myExternalAnnotationsManager == null ? data : this.myExternalAnnotationsManager.internAnnotationData(data));
                this.myAnnotationFqn = null;
                this.myArguments = null;
            }
        }

        @NotNull
        public MostlySingularMultiMap<String, AnnotationData> getResult() {
            if (this.myData.isEmpty()) {
                MostlySingularMultiMap<String, AnnotationData> mostlySingularMultiMap = MostlySingularMultiMap.emptyMap();
                if (mostlySingularMultiMap == null) {
                    DataParsingSaxHandler.$$$reportNull$$$0(1);
                }
                return mostlySingularMultiMap;
            }
            this.myData.compact();
            MostlySingularMultiMap<String, AnnotationData> mostlySingularMultiMap = this.myData;
            if (mostlySingularMultiMap == null) {
                DataParsingSaxHandler.$$$reportNull$$$0(2);
            }
            return mostlySingularMultiMap;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInsight/BaseExternalAnnotationsManager$DataParsingSaxHandler";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInsight/BaseExternalAnnotationsManager$DataParsingSaxHandler";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getResult";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static interface Holder {
        public static final SAXParserFactory FACTORY = SAXParserFactory.newInstance();
    }
}

