/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.kryo.kryo5.util;

import com.esotericsoftware.kryo.kryo5.util.GenericsUtil;
import com.esotericsoftware.kryo.kryo5.util.IntArray;
import com.esotericsoftware.kryo.kryo5.util.Util;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;

public interface Generics {
    public void pushGenericType(GenericType var1);

    public void popGenericType();

    public GenericType[] nextGenericTypes();

    public Class nextGenericClass();

    public int pushTypeVariables(GenericsHierarchy var1, GenericType[] var2);

    public void popTypeVariables(int var1);

    public Class resolveTypeVariable(TypeVariable var1);

    public int getGenericTypesSize();

    public static class GenericType {
        Type type;
        GenericType[] arguments;

        public GenericType(Class fromClass, Class toClass, Type context2) {
            this.initialize(fromClass, toClass, context2);
        }

        private void initialize(Class fromClass, Class toClass, Type context2) {
            if (context2 instanceof ParameterizedType) {
                ParameterizedType paramType = (ParameterizedType)context2;
                Class rawType = (Class)paramType.getRawType();
                this.type = rawType;
                Type[] actualArgs = paramType.getActualTypeArguments();
                int n = actualArgs.length;
                this.arguments = new GenericType[n];
                for (int i = 0; i < n; ++i) {
                    this.arguments[i] = new GenericType(fromClass, toClass, actualArgs[i]);
                }
            } else if (context2 instanceof GenericArrayType) {
                int dimensions = 1;
                while ((context2 = ((GenericArrayType)context2).getGenericComponentType()) instanceof GenericArrayType) {
                    ++dimensions;
                }
                this.initialize(fromClass, toClass, context2);
                Type componentType = GenericsUtil.resolveType(fromClass, toClass, context2);
                if (componentType instanceof Class) {
                    this.type = dimensions == 1 ? Array.newInstance((Class)componentType, 0).getClass() : Array.newInstance((Class)componentType, new int[dimensions]).getClass();
                }
            } else {
                this.type = GenericsUtil.resolveType(fromClass, toClass, context2);
            }
        }

        public Class resolve(Generics generics) {
            if (this.type instanceof Class) {
                return (Class)this.type;
            }
            return generics.resolveTypeVariable((TypeVariable)this.type);
        }

        public Type getType() {
            return this.type;
        }

        public GenericType[] getTypeParameters() {
            return this.arguments;
        }

        public String toString() {
            StringBuilder buffer = new StringBuilder(32);
            boolean array2 = false;
            if (this.type instanceof Class) {
                Class c = (Class)this.type;
                array2 = c.isArray();
                buffer.append((array2 ? Util.getElementClass(c) : c).getSimpleName());
                if (this.arguments != null) {
                    buffer.append('<');
                    int n = this.arguments.length;
                    for (int i = 0; i < n; ++i) {
                        if (i > 0) {
                            buffer.append(", ");
                        }
                        buffer.append(this.arguments[i].toString());
                    }
                    buffer.append('>');
                }
            } else {
                buffer.append(this.type.toString());
            }
            if (array2) {
                int n = Util.getDimensionCount((Class)this.type);
                for (int i = 0; i < n; ++i) {
                    buffer.append("[]");
                }
            }
            return buffer.toString();
        }
    }

    public static class GenericsHierarchy {
        final int total;
        final int rootTotal;
        final int[] counts;
        final TypeVariable[] parameters;

        public GenericsHierarchy(Class type) {
            IntArray counts = new IntArray();
            ArrayList parameters = new ArrayList();
            int total = 0;
            Class current2 = type;
            do {
                for (TypeVariable param : current2.getTypeParameters()) {
                    parameters.add(param);
                    counts.add(1);
                    Class currentSuper = current2;
                    block2: while (true) {
                        Type genericSuper = currentSuper.getGenericSuperclass();
                        currentSuper = currentSuper.getSuperclass();
                        if (!(genericSuper instanceof ParameterizedType)) break;
                        TypeVariable<Class<T>>[] superParams = currentSuper.getTypeParameters();
                        Type[] superArgs = ((ParameterizedType)genericSuper).getActualTypeArguments();
                        int ii = 0;
                        int nn = superArgs.length;
                        while (true) {
                            if (ii >= nn) continue block2;
                            Type superArg = superArgs[ii];
                            if (superArg == param) {
                                param = superParams[ii];
                                parameters.add(param);
                                counts.incr(counts.size - 1, 1);
                            }
                            ++ii;
                        }
                        break;
                    }
                    total += counts.peek();
                }
            } while ((current2 = current2.getSuperclass()) != null);
            this.total = total;
            this.rootTotal = type.getTypeParameters().length;
            this.counts = counts.toArray();
            this.parameters = parameters.toArray(new TypeVariable[parameters.size()]);
        }

        public String toString() {
            StringBuilder buffer = new StringBuilder();
            buffer.append("[");
            int[] counts = this.counts;
            TypeVariable[] parameters = this.parameters;
            int p = 0;
            for (int count2 : counts) {
                int nn = p + count2;
                while (p < nn) {
                    Object declaration;
                    if (buffer.length() > 1) {
                        buffer.append(", ");
                    }
                    if ((declaration = parameters[p].getGenericDeclaration()) instanceof Class) {
                        buffer.append(((Class)declaration).getSimpleName());
                    } else {
                        buffer.append(declaration);
                    }
                    buffer.append('<');
                    buffer.append(parameters[p].getName());
                    buffer.append('>');
                    ++p;
                }
            }
            buffer.append("]");
            return buffer.toString();
        }
    }
}

