/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.kryo.kryo5.io;

import com.esotericsoftware.kryo.kryo5.KryoException;
import com.esotericsoftware.kryo.kryo5.io.Input;
import com.esotericsoftware.kryo.kryo5.io.KryoBufferUnderflowException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class ByteBufferInput
extends Input {
    private static final ByteOrder nativeOrder = ByteOrder.nativeOrder();
    protected ByteBuffer byteBuffer;
    private byte[] tempBuffer;

    public ByteBufferInput() {
    }

    public ByteBufferInput(int bufferSize) {
        this.capacity = bufferSize;
        this.byteBuffer = ByteBuffer.allocateDirect(bufferSize);
    }

    public ByteBufferInput(byte[] bytes) {
        this(bytes, 0, bytes.length);
    }

    public ByteBufferInput(byte[] bytes, int offset, int count2) {
        if (bytes == null) {
            throw new IllegalArgumentException("bytes cannot be null.");
        }
        ByteBuffer buffer = ByteBuffer.allocateDirect(bytes.length);
        buffer.put(bytes);
        this.flipBuffer(buffer);
        this.setBuffer(buffer);
    }

    public ByteBufferInput(ByteBuffer buffer) {
        this.setBuffer(buffer);
    }

    public ByteBufferInput(InputStream inputStream) {
        this(4096);
        if (inputStream == null) {
            throw new IllegalArgumentException("inputStream cannot be null.");
        }
        this.inputStream = inputStream;
    }

    public ByteBufferInput(InputStream inputStream, int bufferSize) {
        this(bufferSize);
        if (inputStream == null) {
            throw new IllegalArgumentException("inputStream cannot be null.");
        }
        this.inputStream = inputStream;
    }

    @Override
    public byte[] getBuffer() {
        throw new UnsupportedOperationException("This input does not used a byte[], see #getByteBuffer().");
    }

    @Override
    public void setBuffer(byte[] bytes) {
        throw new UnsupportedOperationException("This input does not used a byte[], see #setByteBuffer(ByteBuffer).");
    }

    @Override
    public void setBuffer(byte[] bytes, int offset, int count2) {
        throw new UnsupportedOperationException("This input does not used a byte[], see #setByteBufferByteBuffer().");
    }

    public void setBuffer(ByteBuffer buffer) {
        if (buffer == null) {
            throw new IllegalArgumentException("buffer cannot be null.");
        }
        this.byteBuffer = buffer;
        this.position = buffer.position();
        this.limit = buffer.limit();
        this.capacity = buffer.capacity();
        this.total = 0L;
        this.inputStream = null;
    }

    public ByteBuffer getByteBuffer() {
        return this.byteBuffer;
    }

    @Override
    public void setInputStream(InputStream inputStream) {
        this.inputStream = inputStream;
        this.limit = 0;
        this.reset();
    }

    @Override
    public void reset() {
        super.reset();
        this.setBufferPosition(this.byteBuffer, 0);
    }

    protected int fill(ByteBuffer buffer, int offset, int count2) throws KryoException {
        if (this.inputStream == null) {
            return -1;
        }
        try {
            if (this.tempBuffer == null) {
                this.tempBuffer = new byte[2048];
            }
            this.setBufferPosition(buffer, offset);
            int total = 0;
            while (count2 > 0) {
                int read2 = this.inputStream.read(this.tempBuffer, 0, Math.min(this.tempBuffer.length, count2));
                if (read2 == -1) {
                    if (total != 0) break;
                    return -1;
                }
                buffer.put(this.tempBuffer, 0, read2);
                count2 -= read2;
                total += read2;
            }
            return total;
        }
        catch (IOException ex) {
            throw new KryoException(ex);
        }
    }

    @Override
    protected int require(int required) throws KryoException {
        int count2;
        int remaining = this.limit - this.position;
        if (remaining >= required) {
            return remaining;
        }
        if (required > this.capacity) {
            throw new KryoException("Buffer too small: capacity: " + this.capacity + ", required: " + required);
        }
        if (remaining > 0) {
            count2 = this.fill(this.byteBuffer, this.limit, this.capacity - this.limit);
            if (count2 == -1) {
                throw new KryoBufferUnderflowException("Buffer underflow.");
            }
            this.setBufferPosition(this.byteBuffer, this.position);
            if ((remaining += count2) >= required) {
                this.limit += count2;
                return remaining;
            }
        }
        this.byteBuffer.compact();
        this.total += (long)this.position;
        this.position = 0;
        do {
            if ((count2 = this.fill(this.byteBuffer, remaining, this.capacity - remaining)) != -1) continue;
            if (remaining >= required) break;
            throw new KryoBufferUnderflowException("Buffer underflow.");
        } while ((remaining += count2) < required);
        this.limit = remaining;
        this.setBufferPosition(this.byteBuffer, 0);
        return remaining;
    }

    @Override
    protected int optional(int optional) throws KryoException {
        int remaining = this.limit - this.position;
        if (remaining >= optional) {
            return optional;
        }
        optional = Math.min(optional, this.capacity);
        int count2 = this.fill(this.byteBuffer, this.limit, this.capacity - this.limit);
        this.setBufferPosition(this.byteBuffer, this.position);
        if (count2 == -1) {
            return remaining == 0 ? -1 : Math.min(remaining, optional);
        }
        if ((remaining += count2) >= optional) {
            this.limit += count2;
            return optional;
        }
        this.byteBuffer.compact();
        this.total += (long)this.position;
        this.position = 0;
        while ((count2 = this.fill(this.byteBuffer, remaining, this.capacity - remaining)) != -1 && (remaining += count2) < optional) {
        }
        this.limit = remaining;
        this.setBufferPosition(this.byteBuffer, 0);
        return remaining == 0 ? -1 : Math.min(remaining, optional);
    }

    @Override
    public int read() throws KryoException {
        if (this.optional(1) <= 0) {
            return -1;
        }
        ++this.position;
        return this.byteBuffer.get() & 0xFF;
    }

    @Override
    public int read(byte[] bytes) throws KryoException {
        return this.read(bytes, 0, bytes.length);
    }

    @Override
    public int read(byte[] bytes, int offset, int count2) throws KryoException {
        if (bytes == null) {
            throw new IllegalArgumentException("bytes cannot be null.");
        }
        int startingCount = count2;
        int copyCount = Math.min(this.limit - this.position, count2);
        do {
            this.byteBuffer.get(bytes, offset, copyCount);
            this.position += copyCount;
            if ((count2 -= copyCount) == 0) break;
            offset += copyCount;
            copyCount = this.optional(count2);
            if (copyCount != -1) continue;
            if (startingCount == count2) {
                return -1;
            }
            break;
        } while (this.position != this.limit);
        return startingCount - count2;
    }

    @Override
    public void setPosition(int position) {
        this.position = position;
        this.setBufferPosition(this.byteBuffer, position);
    }

    @Override
    public void setLimit(int limit) {
        this.limit = limit;
        this.setBufferLimit(this.byteBuffer, limit);
    }

    @Override
    public void skip(int count2) throws KryoException {
        super.skip(count2);
        this.setBufferPosition(this.byteBuffer, this.position);
    }

    @Override
    public long skip(long count2) throws KryoException {
        int skip;
        for (long remaining = count2; remaining > 0L; remaining -= (long)skip) {
            skip = (int)Math.min(0x7FFFFFF7L, remaining);
            this.skip(skip);
        }
        return count2;
    }

    @Override
    public void close() throws KryoException {
        if (this.inputStream != null) {
            try {
                this.inputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private int getBufferPosition(Buffer buffer) {
        return buffer.position();
    }

    private void setBufferPosition(Buffer buffer, int position) {
        buffer.position(position);
    }

    private void setBufferLimit(Buffer buffer, int limit) {
        buffer.limit(limit);
    }

    private void flipBuffer(Buffer buffer) {
        buffer.flip();
    }

    @Override
    public byte readByte() throws KryoException {
        if (this.position == this.limit) {
            this.require(1);
        }
        ++this.position;
        return this.byteBuffer.get();
    }

    @Override
    public int readByteUnsigned() throws KryoException {
        if (this.position == this.limit) {
            this.require(1);
        }
        ++this.position;
        return this.byteBuffer.get() & 0xFF;
    }

    @Override
    public byte[] readBytes(int length) throws KryoException {
        byte[] bytes = new byte[length];
        this.readBytes(bytes, 0, length);
        return bytes;
    }

    @Override
    public void readBytes(byte[] bytes, int offset, int count2) throws KryoException {
        if (bytes == null) {
            throw new IllegalArgumentException("bytes cannot be null.");
        }
        int copyCount = Math.min(this.limit - this.position, count2);
        while (true) {
            this.byteBuffer.get(bytes, offset, copyCount);
            this.position += copyCount;
            if ((count2 -= copyCount) == 0) break;
            offset += copyCount;
            copyCount = Math.min(count2, this.capacity);
            this.require(copyCount);
        }
    }

    @Override
    public int readInt() throws KryoException {
        this.require(4);
        this.position += 4;
        ByteBuffer byteBuffer = this.byteBuffer;
        return byteBuffer.get() & 0xFF | (byteBuffer.get() & 0xFF) << 8 | (byteBuffer.get() & 0xFF) << 16 | (byteBuffer.get() & 0xFF) << 24;
    }

    @Override
    public int readVarInt(boolean optimizePositive) throws KryoException {
        if (this.require(1) < 5) {
            return this.readVarInt_slow(optimizePositive);
        }
        byte b = this.byteBuffer.get();
        int result2 = b & 0x7F;
        if ((b & 0x80) != 0) {
            ByteBuffer byteBuffer = this.byteBuffer;
            b = byteBuffer.get();
            result2 |= (b & 0x7F) << 7;
            if ((b & 0x80) != 0) {
                b = byteBuffer.get();
                result2 |= (b & 0x7F) << 14;
                if ((b & 0x80) != 0) {
                    b = byteBuffer.get();
                    result2 |= (b & 0x7F) << 21;
                    if ((b & 0x80) != 0) {
                        b = byteBuffer.get();
                        result2 |= (b & 0x7F) << 28;
                    }
                }
            }
        }
        this.position = this.getBufferPosition(this.byteBuffer);
        return optimizePositive ? result2 : result2 >>> 1 ^ -(result2 & 1);
    }

    private int readVarInt_slow(boolean optimizePositive) {
        ++this.position;
        byte b = this.byteBuffer.get();
        int result2 = b & 0x7F;
        if ((b & 0x80) != 0) {
            if (this.position == this.limit) {
                this.require(1);
            }
            ByteBuffer byteBuffer = this.byteBuffer;
            ++this.position;
            b = byteBuffer.get();
            result2 |= (b & 0x7F) << 7;
            if ((b & 0x80) != 0) {
                if (this.position == this.limit) {
                    this.require(1);
                }
                ++this.position;
                b = byteBuffer.get();
                result2 |= (b & 0x7F) << 14;
                if ((b & 0x80) != 0) {
                    if (this.position == this.limit) {
                        this.require(1);
                    }
                    ++this.position;
                    b = byteBuffer.get();
                    result2 |= (b & 0x7F) << 21;
                    if ((b & 0x80) != 0) {
                        if (this.position == this.limit) {
                            this.require(1);
                        }
                        ++this.position;
                        b = byteBuffer.get();
                        result2 |= (b & 0x7F) << 28;
                    }
                }
            }
        }
        return optimizePositive ? result2 : result2 >>> 1 ^ -(result2 & 1);
    }

    @Override
    public boolean canReadVarInt() throws KryoException {
        if (this.limit - this.position >= 5) {
            return true;
        }
        if (this.optional(5) <= 0) {
            return false;
        }
        int p = this.position;
        int limit = this.limit;
        ByteBuffer byteBuffer = this.byteBuffer;
        if ((byteBuffer.get(p++) & 0x80) == 0) {
            return true;
        }
        if (p == limit) {
            return false;
        }
        if ((byteBuffer.get(p++) & 0x80) == 0) {
            return true;
        }
        if (p == limit) {
            return false;
        }
        if ((byteBuffer.get(p++) & 0x80) == 0) {
            return true;
        }
        if (p == limit) {
            return false;
        }
        if ((byteBuffer.get(p++) & 0x80) == 0) {
            return true;
        }
        return p != limit;
    }

    @Override
    public boolean readVarIntFlag() {
        if (this.position == this.limit) {
            this.require(1);
        }
        return (this.byteBuffer.get(this.position) & 0x80) != 0;
    }

    @Override
    public int readVarIntFlag(boolean optimizePositive) {
        if (this.require(1) < 5) {
            return this.readVarIntFlag_slow(optimizePositive);
        }
        byte b = this.byteBuffer.get();
        int result2 = b & 0x3F;
        if ((b & 0x40) != 0) {
            ByteBuffer byteBuffer = this.byteBuffer;
            b = byteBuffer.get();
            result2 |= (b & 0x7F) << 6;
            if ((b & 0x80) != 0) {
                b = byteBuffer.get();
                result2 |= (b & 0x7F) << 13;
                if ((b & 0x80) != 0) {
                    b = byteBuffer.get();
                    result2 |= (b & 0x7F) << 20;
                    if ((b & 0x80) != 0) {
                        b = byteBuffer.get();
                        result2 |= (b & 0x7F) << 27;
                    }
                }
            }
        }
        this.position = this.getBufferPosition(this.byteBuffer);
        return optimizePositive ? result2 : result2 >>> 1 ^ -(result2 & 1);
    }

    private int readVarIntFlag_slow(boolean optimizePositive) {
        ++this.position;
        byte b = this.byteBuffer.get();
        int result2 = b & 0x3F;
        if ((b & 0x40) != 0) {
            if (this.position == this.limit) {
                this.require(1);
            }
            ++this.position;
            ByteBuffer byteBuffer = this.byteBuffer;
            b = byteBuffer.get();
            result2 |= (b & 0x7F) << 6;
            if ((b & 0x80) != 0) {
                if (this.position == this.limit) {
                    this.require(1);
                }
                ++this.position;
                b = byteBuffer.get();
                result2 |= (b & 0x7F) << 13;
                if ((b & 0x80) != 0) {
                    if (this.position == this.limit) {
                        this.require(1);
                    }
                    ++this.position;
                    b = byteBuffer.get();
                    result2 |= (b & 0x7F) << 20;
                    if ((b & 0x80) != 0) {
                        if (this.position == this.limit) {
                            this.require(1);
                        }
                        ++this.position;
                        b = byteBuffer.get();
                        result2 |= (b & 0x7F) << 27;
                    }
                }
            }
        }
        return optimizePositive ? result2 : result2 >>> 1 ^ -(result2 & 1);
    }

    @Override
    public long readLong() throws KryoException {
        this.require(8);
        this.position += 8;
        ByteBuffer byteBuffer = this.byteBuffer;
        return (long)(byteBuffer.get() & 0xFF | (byteBuffer.get() & 0xFF) << 8 | (byteBuffer.get() & 0xFF) << 16) | (long)(byteBuffer.get() & 0xFF) << 24 | (long)(byteBuffer.get() & 0xFF) << 32 | (long)(byteBuffer.get() & 0xFF) << 40 | (long)(byteBuffer.get() & 0xFF) << 48 | (long)byteBuffer.get() << 56;
    }

    @Override
    public long readVarLong(boolean optimizePositive) throws KryoException {
        if (this.require(1) < 9) {
            return this.readVarLong_slow(optimizePositive);
        }
        byte b = this.byteBuffer.get();
        long result2 = b & 0x7F;
        if ((b & 0x80) != 0) {
            ByteBuffer byteBuffer = this.byteBuffer;
            b = byteBuffer.get();
            result2 |= (long)((b & 0x7F) << 7);
            if ((b & 0x80) != 0) {
                b = byteBuffer.get();
                result2 |= (long)((b & 0x7F) << 14);
                if ((b & 0x80) != 0) {
                    b = byteBuffer.get();
                    result2 |= (long)((b & 0x7F) << 21);
                    if ((b & 0x80) != 0) {
                        b = byteBuffer.get();
                        result2 |= (long)(b & 0x7F) << 28;
                        if ((b & 0x80) != 0) {
                            b = byteBuffer.get();
                            result2 |= (long)(b & 0x7F) << 35;
                            if ((b & 0x80) != 0) {
                                b = byteBuffer.get();
                                result2 |= (long)(b & 0x7F) << 42;
                                if ((b & 0x80) != 0) {
                                    b = byteBuffer.get();
                                    result2 |= (long)(b & 0x7F) << 49;
                                    if ((b & 0x80) != 0) {
                                        b = byteBuffer.get();
                                        result2 |= (long)b << 56;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        this.position = this.getBufferPosition(this.byteBuffer);
        return optimizePositive ? result2 : result2 >>> 1 ^ -(result2 & 1L);
    }

    private long readVarLong_slow(boolean optimizePositive) {
        ++this.position;
        byte b = this.byteBuffer.get();
        long result2 = b & 0x7F;
        if ((b & 0x80) != 0) {
            if (this.position == this.limit) {
                this.require(1);
            }
            ByteBuffer byteBuffer = this.byteBuffer;
            ++this.position;
            b = byteBuffer.get();
            result2 |= (long)((b & 0x7F) << 7);
            if ((b & 0x80) != 0) {
                if (this.position == this.limit) {
                    this.require(1);
                }
                ++this.position;
                b = byteBuffer.get();
                result2 |= (long)((b & 0x7F) << 14);
                if ((b & 0x80) != 0) {
                    if (this.position == this.limit) {
                        this.require(1);
                    }
                    ++this.position;
                    b = byteBuffer.get();
                    result2 |= (long)((b & 0x7F) << 21);
                    if ((b & 0x80) != 0) {
                        if (this.position == this.limit) {
                            this.require(1);
                        }
                        ++this.position;
                        b = byteBuffer.get();
                        result2 |= (long)(b & 0x7F) << 28;
                        if ((b & 0x80) != 0) {
                            if (this.position == this.limit) {
                                this.require(1);
                            }
                            ++this.position;
                            b = byteBuffer.get();
                            result2 |= (long)(b & 0x7F) << 35;
                            if ((b & 0x80) != 0) {
                                if (this.position == this.limit) {
                                    this.require(1);
                                }
                                ++this.position;
                                b = byteBuffer.get();
                                result2 |= (long)(b & 0x7F) << 42;
                                if ((b & 0x80) != 0) {
                                    if (this.position == this.limit) {
                                        this.require(1);
                                    }
                                    ++this.position;
                                    b = byteBuffer.get();
                                    result2 |= (long)(b & 0x7F) << 49;
                                    if ((b & 0x80) != 0) {
                                        if (this.position == this.limit) {
                                            this.require(1);
                                        }
                                        ++this.position;
                                        b = byteBuffer.get();
                                        result2 |= (long)b << 56;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return optimizePositive ? result2 : result2 >>> 1 ^ -(result2 & 1L);
    }

    @Override
    public boolean canReadVarLong() throws KryoException {
        if (this.limit - this.position >= 9) {
            return true;
        }
        if (this.optional(5) <= 0) {
            return false;
        }
        int p = this.position;
        int limit = this.limit;
        ByteBuffer byteBuffer = this.byteBuffer;
        if ((byteBuffer.get(p++) & 0x80) == 0) {
            return true;
        }
        if (p == limit) {
            return false;
        }
        if ((byteBuffer.get(p++) & 0x80) == 0) {
            return true;
        }
        if (p == limit) {
            return false;
        }
        if ((byteBuffer.get(p++) & 0x80) == 0) {
            return true;
        }
        if (p == limit) {
            return false;
        }
        if ((byteBuffer.get(p++) & 0x80) == 0) {
            return true;
        }
        if (p == limit) {
            return false;
        }
        if ((byteBuffer.get(p++) & 0x80) == 0) {
            return true;
        }
        if (p == limit) {
            return false;
        }
        if ((byteBuffer.get(p++) & 0x80) == 0) {
            return true;
        }
        if (p == limit) {
            return false;
        }
        if ((byteBuffer.get(p++) & 0x80) == 0) {
            return true;
        }
        if (p == limit) {
            return false;
        }
        if ((byteBuffer.get(p++) & 0x80) == 0) {
            return true;
        }
        return p != limit;
    }

    @Override
    public float readFloat() throws KryoException {
        this.require(4);
        ByteBuffer byteBuffer = this.byteBuffer;
        int p = this.position;
        this.position = p + 4;
        return Float.intBitsToFloat(byteBuffer.get() & 0xFF | (byteBuffer.get() & 0xFF) << 8 | (byteBuffer.get() & 0xFF) << 16 | (byteBuffer.get() & 0xFF) << 24);
    }

    @Override
    public double readDouble() throws KryoException {
        this.require(8);
        ByteBuffer byteBuffer = this.byteBuffer;
        int p = this.position;
        this.position = p + 8;
        return Double.longBitsToDouble((long)(byteBuffer.get() & 0xFF | (byteBuffer.get() & 0xFF) << 8 | (byteBuffer.get() & 0xFF) << 16) | (long)(byteBuffer.get() & 0xFF) << 24 | (long)(byteBuffer.get() & 0xFF) << 32 | (long)(byteBuffer.get() & 0xFF) << 40 | (long)(byteBuffer.get() & 0xFF) << 48 | (long)byteBuffer.get() << 56);
    }

    @Override
    public boolean readBoolean() throws KryoException {
        if (this.position == this.limit) {
            this.require(1);
        }
        ++this.position;
        return this.byteBuffer.get() == 1;
    }

    @Override
    public short readShort() throws KryoException {
        this.require(2);
        this.position += 2;
        return (short)(this.byteBuffer.get() & 0xFF | (this.byteBuffer.get() & 0xFF) << 8);
    }

    @Override
    public int readShortUnsigned() throws KryoException {
        this.require(2);
        this.position += 2;
        return this.byteBuffer.get() & 0xFF | (this.byteBuffer.get() & 0xFF) << 8;
    }

    @Override
    public char readChar() throws KryoException {
        this.require(2);
        this.position += 2;
        return (char)(this.byteBuffer.get() & 0xFF | (this.byteBuffer.get() & 0xFF) << 8);
    }

    @Override
    public String readString() {
        if (!this.readVarIntFlag()) {
            return this.readAsciiString();
        }
        int charCount = this.readVarIntFlag(true);
        switch (charCount) {
            case 0: {
                return null;
            }
            case 1: {
                return "";
            }
        }
        this.readUtf8Chars(--charCount);
        return new String(this.chars, 0, charCount);
    }

    @Override
    public StringBuilder readStringBuilder() {
        if (!this.readVarIntFlag()) {
            return new StringBuilder(this.readAsciiString());
        }
        int charCount = this.readVarIntFlag(true);
        switch (charCount) {
            case 0: {
                return null;
            }
            case 1: {
                return new StringBuilder("");
            }
        }
        this.readUtf8Chars(--charCount);
        StringBuilder builder = new StringBuilder(charCount);
        builder.append(this.chars, 0, charCount);
        return builder;
    }

    private void readUtf8Chars(int charCount) {
        byte b;
        if (this.chars.length < charCount) {
            this.chars = new char[charCount];
        }
        char[] chars = this.chars;
        ByteBuffer byteBuffer = this.byteBuffer;
        int charIndex = 0;
        int count2 = Math.min(this.require(1), charCount);
        while (charIndex < count2 && (b = byteBuffer.get()) >= 0) {
            chars[charIndex++] = (char)b;
        }
        this.position += charIndex;
        if (charIndex < charCount) {
            this.setBufferPosition(byteBuffer, this.position);
            this.readUtf8Chars_slow(charCount, charIndex);
        }
    }

    private void readUtf8Chars_slow(int charCount, int charIndex) {
        ByteBuffer byteBuffer = this.byteBuffer;
        char[] chars = this.chars;
        while (charIndex < charCount) {
            if (this.position == this.limit) {
                this.require(1);
            }
            ++this.position;
            int b = byteBuffer.get() & 0xFF;
            switch (b >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    chars[charIndex] = (char)b;
                    break;
                }
                case 12: 
                case 13: {
                    if (this.position == this.limit) {
                        this.require(1);
                    }
                    ++this.position;
                    chars[charIndex] = (char)((b & 0x1F) << 6 | byteBuffer.get() & 0x3F);
                    break;
                }
                case 14: {
                    this.require(2);
                    this.position += 2;
                    byte b2 = byteBuffer.get();
                    byte b3 = byteBuffer.get();
                    chars[charIndex] = (char)((b & 0xF) << 12 | (b2 & 0x3F) << 6 | b3 & 0x3F);
                }
            }
            ++charIndex;
        }
    }

    private String readAsciiString() {
        int charCount;
        char[] chars = this.chars;
        ByteBuffer byteBuffer = this.byteBuffer;
        int n = Math.min(chars.length, this.limit - this.position);
        for (charCount = 0; charCount < n; ++charCount) {
            byte b = byteBuffer.get();
            if ((b & 0x80) == 128) {
                this.position = this.getBufferPosition(byteBuffer);
                chars[charCount] = (char)(b & 0x7F);
                return new String(chars, 0, charCount + 1);
            }
            chars[charCount] = (char)b;
        }
        this.position = this.getBufferPosition(byteBuffer);
        return this.readAscii_slow(charCount);
    }

    private String readAscii_slow(int charCount) {
        char[] chars = this.chars;
        ByteBuffer byteBuffer = this.byteBuffer;
        while (true) {
            if (this.position == this.limit) {
                this.require(1);
            }
            ++this.position;
            byte b = byteBuffer.get();
            if (charCount == chars.length) {
                char[] newChars = new char[charCount * 2];
                System.arraycopy(chars, 0, newChars, 0, charCount);
                chars = newChars;
                this.chars = newChars;
            }
            if ((b & 0x80) == 128) {
                chars[charCount] = (char)(b & 0x7F);
                return new String(chars, 0, charCount + 1);
            }
            chars[charCount++] = (char)b;
        }
    }

    @Override
    public int[] readInts(int length) throws KryoException {
        int[] array2 = new int[length];
        if (this.optional(length << 2) == length << 2) {
            ByteBuffer byteBuffer = this.byteBuffer;
            for (int i = 0; i < length; ++i) {
                array2[i] = byteBuffer.get() & 0xFF | (byteBuffer.get() & 0xFF) << 8 | (byteBuffer.get() & 0xFF) << 16 | (byteBuffer.get() & 0xFF) << 24;
            }
            this.position = this.getBufferPosition(byteBuffer);
        } else {
            for (int i = 0; i < length; ++i) {
                array2[i] = this.readInt();
            }
        }
        return array2;
    }

    @Override
    public long[] readLongs(int length) throws KryoException {
        long[] array2 = new long[length];
        if (this.optional(length << 3) == length << 3) {
            ByteBuffer byteBuffer = this.byteBuffer;
            for (int i = 0; i < length; ++i) {
                array2[i] = (long)(byteBuffer.get() & 0xFF | (byteBuffer.get() & 0xFF) << 8 | (byteBuffer.get() & 0xFF) << 16) | (long)(byteBuffer.get() & 0xFF) << 24 | (long)(byteBuffer.get() & 0xFF) << 32 | (long)(byteBuffer.get() & 0xFF) << 40 | (long)(byteBuffer.get() & 0xFF) << 48 | (long)byteBuffer.get() << 56;
            }
            this.position = this.getBufferPosition(byteBuffer);
        } else {
            for (int i = 0; i < length; ++i) {
                array2[i] = this.readLong();
            }
        }
        return array2;
    }

    @Override
    public float[] readFloats(int length) throws KryoException {
        float[] array2 = new float[length];
        if (this.optional(length << 2) == length << 2) {
            ByteBuffer byteBuffer = this.byteBuffer;
            for (int i = 0; i < length; ++i) {
                array2[i] = Float.intBitsToFloat(byteBuffer.get() & 0xFF | (byteBuffer.get() & 0xFF) << 8 | (byteBuffer.get() & 0xFF) << 16 | (byteBuffer.get() & 0xFF) << 24);
            }
            this.position = this.getBufferPosition(byteBuffer);
        } else {
            for (int i = 0; i < length; ++i) {
                array2[i] = this.readFloat();
            }
        }
        return array2;
    }

    @Override
    public double[] readDoubles(int length) throws KryoException {
        double[] array2 = new double[length];
        if (this.optional(length << 3) == length << 3) {
            ByteBuffer byteBuffer = this.byteBuffer;
            for (int i = 0; i < length; ++i) {
                array2[i] = Double.longBitsToDouble((long)(byteBuffer.get() & 0xFF | (byteBuffer.get() & 0xFF) << 8 | (byteBuffer.get() & 0xFF) << 16) | (long)(byteBuffer.get() & 0xFF) << 24 | (long)(byteBuffer.get() & 0xFF) << 32 | (long)(byteBuffer.get() & 0xFF) << 40 | (long)(byteBuffer.get() & 0xFF) << 48 | (long)byteBuffer.get() << 56);
            }
            this.position = this.getBufferPosition(byteBuffer);
        } else {
            for (int i = 0; i < length; ++i) {
                array2[i] = this.readDouble();
            }
        }
        return array2;
    }

    @Override
    public short[] readShorts(int length) throws KryoException {
        short[] array2 = new short[length];
        if (this.optional(length << 1) == length << 1) {
            ByteBuffer byteBuffer = this.byteBuffer;
            for (int i = 0; i < length; ++i) {
                array2[i] = (short)(byteBuffer.get() & 0xFF | (byteBuffer.get() & 0xFF) << 8);
            }
            this.position = this.getBufferPosition(byteBuffer);
        } else {
            for (int i = 0; i < length; ++i) {
                array2[i] = this.readShort();
            }
        }
        return array2;
    }

    @Override
    public char[] readChars(int length) throws KryoException {
        char[] array2 = new char[length];
        if (this.optional(length << 1) == length << 1) {
            ByteBuffer byteBuffer = this.byteBuffer;
            for (int i = 0; i < length; ++i) {
                array2[i] = (char)(byteBuffer.get() & 0xFF | (byteBuffer.get() & 0xFF) << 8);
            }
            this.position = this.getBufferPosition(byteBuffer);
        } else {
            for (int i = 0; i < length; ++i) {
                array2[i] = this.readChar();
            }
        }
        return array2;
    }

    @Override
    public boolean[] readBooleans(int length) throws KryoException {
        boolean[] array2 = new boolean[length];
        if (this.optional(length) == length) {
            ByteBuffer byteBuffer = this.byteBuffer;
            for (int i = 0; i < length; ++i) {
                array2[i] = byteBuffer.get() != 0;
            }
            this.position = this.getBufferPosition(byteBuffer);
        } else {
            for (int i = 0; i < length; ++i) {
                array2[i] = this.readBoolean();
            }
        }
        return array2;
    }
}

