/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.apk.analyzer.internal;

import com.android.tools.apk.analyzer.internal.ZipArchive;
import com.google.common.primitives.Shorts;
import java.io.IOException;
import java.nio.file.Path;

public class ApkArchive
extends ZipArchive {
    public static final String APK_BASELINE_PROFILE_PATH = String.format("/%s/%s", "assets/dexopt", "baseline.prof");
    public static final String APK_BASELINE_PROFILE_METADATA_PATH = String.format("/%s/%s", "assets/dexopt", "baseline.profm");

    public ApkArchive(Path artifact) throws IOException {
        super(artifact);
    }

    @Override
    public boolean isBinaryXml(Path p, byte[] content) {
        boolean xmlResource;
        if (!p.toString().endsWith(".xml")) {
            return false;
        }
        Path name = p.getFileName();
        if (name == null) {
            return false;
        }
        Path contents = this.getContentRoot();
        boolean manifest = p.equals(contents.resolve("AndroidManifest.xml"));
        boolean insideResFolder = p.startsWith(contents.resolve("res"));
        boolean insideResRaw = p.startsWith(contents.resolve("res").resolve("raw"));
        boolean bl = xmlResource = insideResFolder && !insideResRaw;
        if (!manifest && !xmlResource) {
            return false;
        }
        short code = Shorts.fromBytes((byte)content[1], (byte)content[0]);
        return code == 3;
    }

    @Override
    public boolean isBaselineProfile(Path p, byte[] content) {
        String path = p.toString();
        return path.equals(APK_BASELINE_PROFILE_PATH) || path.equals(APK_BASELINE_PROFILE_METADATA_PATH);
    }
}

